/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MutableCoercionConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import java.io.Serializable;
import java.util.Map;

public class CoercionConfigs
implements Serializable {
    private static final int TARGET_TYPE_COUNT = LogicalType.values().length;
    protected CoercionAction _defaultAction;
    protected final MutableCoercionConfig _defaultCoercions;
    protected MutableCoercionConfig[] _perTypeCoercions;
    protected Map<Class<?>, MutableCoercionConfig> _perClassCoercions;

    public CoercionConfigs() {
        this(CoercionAction.TryConvert, new MutableCoercionConfig(), null, null);
    }

    protected CoercionConfigs(CoercionAction defaultAction, MutableCoercionConfig defaultCoercions, MutableCoercionConfig[] perTypeCoercions, Map<Class<?>, MutableCoercionConfig> perClassCoercions) {
        this._defaultCoercions = defaultCoercions;
        this._defaultAction = defaultAction;
        this._perTypeCoercions = perTypeCoercions;
        this._perClassCoercions = perClassCoercions;
    }

    public CoercionAction findCoercion(DeserializationConfig config, LogicalType targetType, Class<?> targetClass, CoercionInputShape inputShape) {
        boolean baseScalar;
        CoercionAction act;
        MutableCoercionConfig cc2;
        if (this._perClassCoercions != null && targetClass != null && (cc2 = this._perClassCoercions.get(targetClass)) != null && (act = cc2.findAction(inputShape)) != null) {
            return act;
        }
        if (this._perTypeCoercions != null && targetType != null && (cc2 = this._perTypeCoercions[targetType.ordinal()]) != null && (act = cc2.findAction(inputShape)) != null) {
            return act;
        }
        CoercionAction act2 = this._defaultCoercions.findAction(inputShape);
        if (act2 != null) {
            return act2;
        }
        switch (inputShape) {
            case EmptyArray: {
                return config.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT) ? CoercionAction.AsNull : CoercionAction.Fail;
            }
            case Float: {
                if (targetType != LogicalType.Integer) break;
                return config.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT) ? CoercionAction.TryConvert : CoercionAction.Fail;
            }
            case Integer: {
                if (targetType != LogicalType.Enum || !config.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) break;
                return CoercionAction.Fail;
            }
        }
        boolean bl2 = baseScalar = targetType == LogicalType.Float || targetType == LogicalType.Integer || targetType == LogicalType.Boolean || targetType == LogicalType.DateTime;
        if (baseScalar && !config.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            return CoercionAction.Fail;
        }
        if (inputShape == CoercionInputShape.EmptyString) {
            if (baseScalar || config.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
                return CoercionAction.AsNull;
            }
            if (targetType == LogicalType.OtherScalar) {
                return CoercionAction.TryConvert;
            }
            return CoercionAction.Fail;
        }
        return this._defaultAction;
    }

    public CoercionAction findCoercionFromBlankString(DeserializationConfig config, LogicalType targetType, Class<?> targetClass, CoercionAction actionIfBlankNotAllowed) {
        MutableCoercionConfig cc2;
        Boolean acceptBlankAsEmpty = null;
        CoercionAction action = null;
        if (this._perClassCoercions != null && targetClass != null && (cc2 = this._perClassCoercions.get(targetClass)) != null) {
            acceptBlankAsEmpty = cc2.getAcceptBlankAsEmpty();
            action = cc2.findAction(CoercionInputShape.EmptyString);
        }
        if (this._perTypeCoercions != null && targetType != null && (cc2 = this._perTypeCoercions[targetType.ordinal()]) != null) {
            if (acceptBlankAsEmpty == null) {
                acceptBlankAsEmpty = cc2.getAcceptBlankAsEmpty();
            }
            if (action == null) {
                action = cc2.findAction(CoercionInputShape.EmptyString);
            }
        }
        if (acceptBlankAsEmpty == null) {
            acceptBlankAsEmpty = this._defaultCoercions.getAcceptBlankAsEmpty();
        }
        if (action == null) {
            action = this._defaultCoercions.findAction(CoercionInputShape.EmptyString);
        }
        if (!Boolean.TRUE.equals(acceptBlankAsEmpty)) {
            return actionIfBlankNotAllowed;
        }
        if (action != null) {
            return action;
        }
        return config.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) ? CoercionAction.AsNull : CoercionAction.Fail;
    }
}

