/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.Builder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.ModelBuilderFactory;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.impl.ModelBuilder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.JavaClassContext;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultDocletTagFactory;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.ClassDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.writer.ModelWriterFactory;

public abstract class AbstractClassLibrary
implements ClassLibrary {
    private AbstractClassLibrary parentClassLibrary;
    private ModelBuilderFactory modelBuilderFactory;
    private ModelWriterFactory modelWriterFactory;
    private JavaClassContext context = new JavaClassContext();

    public AbstractClassLibrary() {
    }

    public AbstractClassLibrary(AbstractClassLibrary parent) {
        this.parentClassLibrary = parent;
    }

    @Override
    public final JavaClass getJavaClass(String name) {
        return this.getJavaClass(name, false);
    }

    public final JavaClass getJavaClass(String name, boolean createStub) {
        JavaClass result = this.context.getClassByName(name);
        if (result == null && (result = this.resolveJavaClass(name)) != null) {
            this.context.add(result);
            this.context.add(result.getSource());
            JavaPackage contextPackage = this.context.getPackageByName(result.getPackageName());
            if (contextPackage == null) {
                DefaultJavaPackage newContextPackage = new DefaultJavaPackage(result.getPackageName());
                newContextPackage.setClassLibrary(this);
                this.context.add(newContextPackage);
                contextPackage = newContextPackage;
            }
            contextPackage.getClasses().addAll(result.getNestedClasses());
        }
        if (result == null && this.parentClassLibrary != null) {
            result = this.parentClassLibrary.getJavaClass(name);
        }
        if (result == null && createStub) {
            result = this.createStub(name);
        }
        return result;
    }

    private JavaClass createStub(String name) {
        Builder unknownBuilder = this.getModelBuilder();
        unknownBuilder.beginClass(new ClassDef(name));
        unknownBuilder.endClass();
        JavaSource unknownSource = unknownBuilder.getSource();
        return unknownSource.getClasses().get(0);
    }

    protected abstract JavaClass resolveJavaClass(String var1);

    @Override
    public final JavaPackage getJavaPackage(String name) {
        JavaPackage result = this.context.getPackageByName(name);
        if (result == null && (result = this.resolveJavaPackage(name)) != null) {
            this.context.add(result);
        }
        if (result == null && this.parentClassLibrary != null) {
            result = this.parentClassLibrary.getJavaPackage(name);
        }
        return result;
    }

    protected abstract JavaPackage resolveJavaPackage(String var1);

    @Override
    public boolean hasClassReference(String name) {
        boolean result;
        boolean bl2 = result = this.context.getClassByName(name) != null;
        if (!result) {
            result = this.containsClassReference(name);
        }
        if (!result && this.parentClassLibrary != null) {
            result = this.parentClassLibrary.hasClassReference(name);
        }
        return result;
    }

    protected abstract boolean containsClassReference(String var1);

    protected Builder getModelBuilder() {
        ModelBuilder result = this.modelBuilderFactory != null ? this.modelBuilderFactory.newInstance(this) : new ModelBuilder(this, new DefaultDocletTagFactory());
        result.setModelWriterFactory(this.modelWriterFactory);
        return result;
    }
}

