/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.objenesis.instantiator.ObjectInstantiator;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.Util;

public class Registration {
    private final Class type;
    private final boolean typeNameAscii;
    private final int id;
    private Serializer serializer;
    private ObjectInstantiator instantiator;

    public Registration(Class type, Serializer serializer, int id) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.typeNameAscii = Util.isAscii(type.getName());
    }

    public Class getType() {
        return this.type;
    }

    public boolean isTypeNameAscii() {
        return this.typeNameAscii;
    }

    public int getId() {
        return this.id;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.serializer = serializer;
        if (Log.TRACE) {
            Log.trace("kryo", "Update registered serializer: " + this.type.getName() + " (" + serializer.getClass().getName() + ")");
        }
    }

    public ObjectInstantiator getInstantiator() {
        return this.instantiator;
    }

    public void setInstantiator(ObjectInstantiator instantiator) {
        if (instantiator == null) {
            throw new IllegalArgumentException("instantiator cannot be null.");
        }
        this.instantiator = instantiator;
    }

    public String toString() {
        return "[" + this.id + ", " + Util.className(this.type) + "]";
    }
}

