/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import java.util.Random;

public class CuckooObjectMap<K, V> {
    static Random random = new Random();
    public int size;
    K[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private boolean isBigTable;

    public CuckooObjectMap() {
        this(32, 0.8f);
    }

    public CuckooObjectMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + initialCapacity);
        }
        this.capacity = CuckooObjectMap.nextPowerOfTwo(initialCapacity);
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.isBigTable = this.capacity >>> 16 != 0;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        return this.put_internal(key, value);
    }

    private V put_internal(K key, V value) {
        int i2;
        K[] keyTable = this.keyTable;
        int mask = this.mask;
        boolean isBigTable = this.isBigTable;
        int hashCode = key.hashCode();
        int index1 = hashCode & mask;
        K key1 = keyTable[index1];
        if (key.equals(key1)) {
            V oldValue = this.valueTable[index1];
            this.valueTable[index1] = value;
            return oldValue;
        }
        int index2 = this.hash2(hashCode);
        K key2 = keyTable[index2];
        if (key.equals(key2)) {
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = value;
            return oldValue;
        }
        int index3 = this.hash3(hashCode);
        K key3 = keyTable[index3];
        if (key.equals(key3)) {
            V oldValue = this.valueTable[index3];
            this.valueTable[index3] = value;
            return oldValue;
        }
        int index4 = -1;
        K key4 = null;
        if (isBigTable && key.equals(key4 = (K)keyTable[index4 = this.hash4(hashCode)])) {
            V oldValue = this.valueTable[index4];
            this.valueTable[index4] = value;
            return oldValue;
        }
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (!key.equals(keyTable[i2])) continue;
            V oldValue = this.valueTable[i2];
            this.valueTable[i2] = value;
            return oldValue;
        }
        if (key1 == null) {
            keyTable[index1] = key;
            this.valueTable[index1] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (key2 == null) {
            keyTable[index2] = key;
            this.valueTable[index2] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (key3 == null) {
            keyTable[index3] = key;
            this.valueTable[index3] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (isBigTable && key4 == null) {
            keyTable[index4] = key;
            this.valueTable[index4] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(key, value, index1, key1, index2, key2, index3, key3, index4, key4);
        return null;
    }

    private void putResize(K key, V value) {
        int hashCode = key.hashCode();
        int index1 = hashCode & this.mask;
        K key1 = this.keyTable[index1];
        if (key1 == null) {
            this.keyTable[index1] = key;
            this.valueTable[index1] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index2 = this.hash2(hashCode);
        K key2 = this.keyTable[index2];
        if (key2 == null) {
            this.keyTable[index2] = key;
            this.valueTable[index2] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index3 = this.hash3(hashCode);
        K key3 = this.keyTable[index3];
        if (key3 == null) {
            this.keyTable[index3] = key;
            this.valueTable[index3] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index4 = -1;
        K key4 = null;
        if (this.isBigTable && (key4 = (K)this.keyTable[index4 = this.hash4(hashCode)]) == null) {
            this.keyTable[index4] = key;
            this.valueTable[index4] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(key, value, index1, key1, index2, key2, index3, key3, index4, key4);
    }

    private void push(K insertKey, V insertValue, int index1, K key1, int index2, K key2, int index3, K key3, int index4, K key4) {
        V evictedValue;
        K evictedKey;
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int mask = this.mask;
        boolean isBigTable = this.isBigTable;
        int i2 = 0;
        int pushIterations = this.pushIterations;
        int n2 = isBigTable ? 4 : 3;
        while (true) {
            switch (random.nextInt(n2)) {
                case 0: {
                    evictedKey = key1;
                    evictedValue = valueTable[index1];
                    keyTable[index1] = insertKey;
                    valueTable[index1] = insertValue;
                    break;
                }
                case 1: {
                    evictedKey = key2;
                    evictedValue = valueTable[index2];
                    keyTable[index2] = insertKey;
                    valueTable[index2] = insertValue;
                    break;
                }
                case 2: {
                    evictedKey = key3;
                    evictedValue = valueTable[index3];
                    keyTable[index3] = insertKey;
                    valueTable[index3] = insertValue;
                    break;
                }
                default: {
                    evictedKey = key4;
                    evictedValue = valueTable[index4];
                    keyTable[index4] = insertKey;
                    valueTable[index4] = insertValue;
                }
            }
            int hashCode = evictedKey.hashCode();
            index1 = hashCode & mask;
            key1 = keyTable[index1];
            if (key1 == null) {
                keyTable[index1] = evictedKey;
                valueTable[index1] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            index2 = this.hash2(hashCode);
            key2 = keyTable[index2];
            if (key2 == null) {
                keyTable[index2] = evictedKey;
                valueTable[index2] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            index3 = this.hash3(hashCode);
            key3 = keyTable[index3];
            if (key3 == null) {
                keyTable[index3] = evictedKey;
                valueTable[index3] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (isBigTable && (key4 = keyTable[index4 = this.hash4(hashCode)]) == null) {
                keyTable[index4] = evictedKey;
                valueTable[index4] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++i2 == pushIterations) break;
            insertKey = evictedKey;
            insertValue = evictedValue;
        }
        this.putStash(evictedKey, evictedValue);
    }

    private void putStash(K key, V value) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put_internal(key, value);
            return;
        }
        int index = this.capacity + this.stashSize;
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        ++this.stashSize;
        ++this.size;
    }

    public V get(K key) {
        int hashCode = key.hashCode();
        int index = hashCode & this.mask;
        if (!(key.equals(this.keyTable[index]) || key.equals(this.keyTable[index = this.hash2(hashCode)]) || key.equals(this.keyTable[index = this.hash3(hashCode)]))) {
            if (this.isBigTable) {
                index = this.hash4(hashCode);
                if (!key.equals(this.keyTable[index])) {
                    return this.getStash(key);
                }
            } else {
                return this.getStash(key);
            }
        }
        return this.valueTable[index];
    }

    private V getStash(K key) {
        int i2;
        K[] keyTable = this.keyTable;
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (!key.equals(keyTable[i2])) continue;
            return this.valueTable[i2];
        }
        return null;
    }

    public V remove(K key) {
        int hashCode = key.hashCode();
        int index = hashCode & this.mask;
        if (key.equals(this.keyTable[index])) {
            this.keyTable[index] = null;
            V oldValue = this.valueTable[index];
            this.valueTable[index] = null;
            --this.size;
            return oldValue;
        }
        index = this.hash2(hashCode);
        if (key.equals(this.keyTable[index])) {
            this.keyTable[index] = null;
            V oldValue = this.valueTable[index];
            this.valueTable[index] = null;
            --this.size;
            return oldValue;
        }
        index = this.hash3(hashCode);
        if (key.equals(this.keyTable[index])) {
            this.keyTable[index] = null;
            V oldValue = this.valueTable[index];
            this.valueTable[index] = null;
            --this.size;
            return oldValue;
        }
        if (this.isBigTable && key.equals(this.keyTable[index = this.hash4(hashCode)])) {
            this.keyTable[index] = null;
            V oldValue = this.valueTable[index];
            this.valueTable[index] = null;
            --this.size;
            return oldValue;
        }
        return this.removeStash(key);
    }

    V removeStash(K key) {
        int i2;
        K[] keyTable = this.keyTable;
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (!key.equals(keyTable[i2])) continue;
            V oldValue = this.valueTable[i2];
            this.removeStashIndex(i2);
            --this.size;
            return oldValue;
        }
        return null;
    }

    void removeStashIndex(int index) {
        --this.stashSize;
        int lastIndex = this.capacity + this.stashSize;
        if (index < lastIndex) {
            this.keyTable[index] = this.keyTable[lastIndex];
            this.valueTable[index] = this.valueTable[lastIndex];
            this.valueTable[lastIndex] = null;
        } else {
            this.valueTable[index] = null;
        }
    }

    private void resize(int newSize) {
        int oldEndIndex = this.capacity + this.stashSize;
        this.capacity = newSize;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(newSize);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(newSize)) * 2);
        this.pushIterations = Math.max(Math.min(newSize, 8), (int)Math.sqrt(newSize) / 8);
        this.isBigTable = this.capacity >>> 16 != 0;
        K[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize + this.stashCapacity];
        this.valueTable = new Object[newSize + this.stashCapacity];
        int oldSize = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (oldSize > 0) {
            for (int i2 = 0; i2 < oldEndIndex; ++i2) {
                K key = oldKeyTable[i2];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i2]);
            }
        }
    }

    private int hash2(int h2) {
        return ((h2 *= -1105259343) ^ h2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int h2) {
        return ((h2 *= -1262997959) ^ h2 >>> this.hashShift) & this.mask;
    }

    private int hash4(int h2) {
        return ((h2 *= -825114047) ^ h2 >>> this.hashShift) & this.mask;
    }

    public String toString() {
        K key;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i2 = keyTable.length;
        while (i2-- > 0) {
            key = keyTable[i2];
            if (key == null) continue;
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i2]);
            break;
        }
        while (i2-- > 0) {
            key = keyTable[i2];
            if (key == null) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i2]);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }
}

