/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.KryoException;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntMap<V>
implements Iterable<Entry<V>> {
    public int size;
    int[] keyTable;
    V[] valueTable;
    V zeroValue;
    boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    protected int shift;
    protected int mask;

    public IntMap() {
        this(51, 0.8f);
    }

    public IntMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public IntMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[tableSize];
        this.valueTable = new Object[tableSize];
    }

    protected int place(int item) {
        return (int)((long)item * -7046029254386353131L >>> this.shift);
    }

    private int locateKey(int key) {
        int[] keyTable = this.keyTable;
        int i2 = this.place(key);
        int other;
        while ((other = keyTable[i2]) != 0) {
            if (other == key) {
                return i2;
            }
            i2 = i2 + 1 & this.mask;
        }
        return -(i2 + 1);
    }

    public V put(int key, V value) {
        if (key == 0) {
            V oldValue = this.zeroValue;
            this.zeroValue = value;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return oldValue;
        }
        int i2 = this.locateKey(key);
        if (i2 >= 0) {
            V oldValue = this.valueTable[i2];
            this.valueTable[i2] = value;
            return oldValue;
        }
        i2 = -(i2 + 1);
        this.keyTable[i2] = key;
        this.valueTable[i2] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    private void putResize(int key, V value) {
        int[] keyTable = this.keyTable;
        int i2 = this.place(key);
        while (true) {
            if (keyTable[i2] == 0) {
                keyTable[i2] = key;
                this.valueTable[i2] = value;
                return;
            }
            i2 = i2 + 1 & this.mask;
        }
    }

    public V get(int key) {
        if (key == 0) {
            return this.hasZeroValue ? (V)this.zeroValue : null;
        }
        int i2 = this.locateKey(key);
        return i2 >= 0 ? (V)this.valueTable[i2] : null;
    }

    public V get(int key, V defaultValue) {
        if (key == 0) {
            return this.hasZeroValue ? this.zeroValue : defaultValue;
        }
        int i2 = this.locateKey(key);
        return i2 >= 0 ? this.valueTable[i2] : defaultValue;
    }

    public V remove(int key) {
        if (key == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            V oldValue = this.zeroValue;
            this.zeroValue = null;
            --this.size;
            return oldValue;
        }
        int i2 = this.locateKey(key);
        if (i2 < 0) {
            return null;
        }
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i2];
        int mask = this.mask;
        int next = i2 + 1 & mask;
        while ((key = keyTable[next]) != 0) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i2 - placement & mask)) {
                keyTable[i2] = key;
                valueTable[i2] = valueTable[next];
                i2 = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i2] = 0;
        --this.size;
        return oldValue;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, 0);
        Arrays.fill(this.valueTable, null);
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsKey(int key) {
        if (key == 0) {
            return this.hasZeroValue;
        }
        return this.locateKey(key) >= 0;
    }

    private void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new int[newSize];
        this.valueTable = new Object[newSize];
        if (this.size > 0) {
            for (int i2 = 0; i2 < oldCapacity; ++i2) {
                int key = oldKeyTable[i2];
                if (key == 0) continue;
                this.putResize(key, oldValueTable[i2]);
            }
        }
    }

    public int hashCode() {
        int h2 = this.size;
        if (this.hasZeroValue && this.zeroValue != null) {
            h2 += this.zeroValue.hashCode();
        }
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n2 = keyTable.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int key = keyTable[i2];
            if (key == 0) continue;
            h2 += key * 31;
            V value = valueTable[i2];
            if (value == null) continue;
            h2 += value.hashCode();
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntMap)) {
            return false;
        }
        IntMap other = (IntMap)obj;
        if (other.size != this.size) {
            return false;
        }
        if (other.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (other.zeroValue == null ? this.zeroValue != null : !other.zeroValue.equals(this.zeroValue))) {
            return false;
        }
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n2 = keyTable.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V value;
            int key = keyTable[i2];
            if (key == 0 || !((value = valueTable[i2]) == null ? other.get(key, ObjectMap.dummy) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int key;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i2 = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0=");
            buffer.append(this.zeroValue);
        } else {
            while (i2-- > 0) {
                key = keyTable[i2];
                if (key == 0) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(valueTable[i2]);
                break;
            }
        }
        while (i2-- > 0) {
            key = keyTable[i2];
            if (key == 0) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i2]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Entries<V> entries() {
        return new Entries(this);
    }

    public static class Entries<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private final Entry<V> entry = new Entry();

        public Entries(IntMap map) {
            super(map);
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new KryoException("#iterator() cannot be used nested.");
            }
            int[] keyTable = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = keyTable[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new KryoException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }
    }

    private static class MapIterator<V> {
        public boolean hasNext;
        final IntMap<V> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(IntMap<V> map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            int[] keyTable = this.map.keyTable;
            int n2 = keyTable.length;
            while (++this.nextIndex < n2) {
                if (keyTable[this.nextIndex] == 0) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        public void remove() {
            int i2 = this.currentIndex;
            if (i2 == -1 && this.map.hasZeroValue) {
                this.map.hasZeroValue = false;
            } else {
                int key;
                if (i2 < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                int[] keyTable = this.map.keyTable;
                V[] valueTable = this.map.valueTable;
                int mask = this.map.mask;
                int next = i2 + 1 & mask;
                while ((key = keyTable[next]) != 0) {
                    int placement = this.map.place(key);
                    if ((next - placement & mask) > (i2 - placement & mask)) {
                        keyTable[i2] = key;
                        valueTable[i2] = valueTable[next];
                        i2 = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i2] = 0;
                if (i2 != this.currentIndex) {
                    --this.nextIndex;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    public static class Entry<V> {
        public int key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

