/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EnumResolver
implements Serializable {
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;
    protected final boolean _isIgnoreCase;

    protected EnumResolver(Class<Enum<?>> enumClass, Enum<?>[] enums, HashMap<String, Enum<?>> map, Enum<?> defaultValue, boolean isIgnoreCase) {
        this._enumClass = enumClass;
        this._enums = enums;
        this._enumsById = map;
        this._defaultValue = defaultValue;
        this._isIgnoreCase = isIgnoreCase;
    }

    public static EnumResolver constructFor(DeserializationConfig config, Class<?> enumCls) {
        return EnumResolver._constructFor(enumCls, config.getAnnotationIntrospector(), config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    protected static EnumResolver _constructFor(Class<?> enumCls0, AnnotationIntrospector ai2, boolean isIgnoreCase) {
        Class<Enum<?>> enumCls = EnumResolver._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumResolver._enumConstants(enumCls0);
        String[] names = ai2.findEnumValues(enumCls, enumConstants, new String[enumConstants.length]);
        String[][] allAliases = new String[names.length][];
        ai2.findEnumAliases(enumCls, enumConstants, allAliases);
        HashMap map = new HashMap();
        int len = enumConstants.length;
        for (int i2 = 0; i2 < len; ++i2) {
            Enum<?> enumValue = enumConstants[i2];
            String name = names[i2];
            if (name == null) {
                name = enumValue.name();
            }
            map.put(name, enumValue);
            String[] aliases = allAliases[i2];
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (map.containsKey(alias)) continue;
                map.put(alias, enumValue);
            }
        }
        return new EnumResolver(enumCls, enumConstants, map, EnumResolver._enumDefault(ai2, enumCls), isIgnoreCase);
    }

    public static EnumResolver constructUsingToString(DeserializationConfig config, Class<?> enumCls) {
        return EnumResolver._constructUsingToString(enumCls, config.getAnnotationIntrospector(), config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    protected static EnumResolver _constructUsingToString(Class<?> enumCls0, AnnotationIntrospector ai2, boolean isIgnoreCase) {
        Class<Enum<?>> enumCls = EnumResolver._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumResolver._enumConstants(enumCls0);
        HashMap map = new HashMap();
        String[][] allAliases = new String[enumConstants.length][];
        ai2.findEnumAliases(enumCls, enumConstants, allAliases);
        int i2 = enumConstants.length;
        while (--i2 >= 0) {
            Enum<?> enumValue = enumConstants[i2];
            map.put(enumValue.toString(), enumValue);
            String[] aliases = allAliases[i2];
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (map.containsKey(alias)) continue;
                map.put(alias, enumValue);
            }
        }
        return new EnumResolver(enumCls, enumConstants, map, EnumResolver._enumDefault(ai2, enumCls), isIgnoreCase);
    }

    public static EnumResolver constructUsingMethod(DeserializationConfig config, Class<?> enumCls, AnnotatedMember accessor) {
        return EnumResolver._constructUsingMethod(enumCls, accessor, config.getAnnotationIntrospector(), config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    protected static EnumResolver _constructUsingMethod(Class<?> enumCls0, AnnotatedMember accessor, AnnotationIntrospector ai2, boolean isIgnoreCase) {
        Class<Enum<?>> enumCls = EnumResolver._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumResolver._enumConstants(enumCls0);
        HashMap map = new HashMap();
        int i2 = enumConstants.length;
        while (--i2 >= 0) {
            Enum<?> en = enumConstants[i2];
            try {
                Object o2 = accessor.getValue(en);
                if (o2 == null) continue;
                map.put(o2.toString(), en);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + en + ": " + e2.getMessage());
            }
        }
        return new EnumResolver(enumCls, enumConstants, map, EnumResolver._enumDefault(ai2, enumCls), isIgnoreCase);
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> enumCls0) {
        return enumCls0;
    }

    protected static Enum<?>[] _enumConstants(Class<?> enumCls) {
        Enum<?>[] enumValues = EnumResolver._enumClass(enumCls).getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("No enum constants for class " + enumCls.getName());
        }
        return enumValues;
    }

    protected static Enum<?> _enumDefault(AnnotationIntrospector intr, Class<?> enumCls) {
        return intr != null ? intr.findDefaultEnumValue(EnumResolver._enumClass(enumCls)) : null;
    }

    public Enum<?> findEnum(String key) {
        Enum<?> en = this._enumsById.get(key);
        if (en == null && this._isIgnoreCase) {
            return this._findEnumCaseInsensitive(key);
        }
        return en;
    }

    protected Enum<?> _findEnumCaseInsensitive(String key) {
        for (Map.Entry<String, Enum<?>> entry : this._enumsById.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

