/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.jodah.failsafe;

import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.AbstractExecution;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.ExecutionResult;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.FailsafeExecutor;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.FailsafeFuture;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.Functions;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.PolicyExecutor;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.util.concurrent.Scheduler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class AsyncExecution<R>
extends AbstractExecution<R> {
    private Functions.SettableSupplier<CompletableFuture<ExecutionResult>> innerExecutionSupplier;
    private Supplier<CompletableFuture<ExecutionResult>> outerExecutionSupplier;
    final FailsafeFuture<R> future;
    private volatile boolean completeCalled;
    private volatile boolean retryCalled;

    AsyncExecution(Scheduler scheduler, FailsafeFuture<R> future, FailsafeExecutor<R> executor) {
        super(scheduler, executor);
        this.future = future;
    }

    void inject(Supplier<CompletableFuture<ExecutionResult>> syncSupplier, boolean asyncExecution) {
        if (!asyncExecution) {
            this.outerExecutionSupplier = Functions.getPromiseAsync(syncSupplier, this.scheduler, this);
        } else {
            this.innerExecutionSupplier = Functions.toSettableSupplier(syncSupplier);
            this.outerExecutionSupplier = this.innerExecutionSupplier;
        }
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerExecutionSupplier = policyExecutor.supplyAsync(this.outerExecutionSupplier, this.scheduler, this.future);
        }
    }

    @Override
    void preExecute() {
        super.preExecute();
        this.completeCalled = false;
        this.retryCalled = false;
    }

    void executeAsync(boolean asyncExecution) {
        if (!asyncExecution) {
            this.outerExecutionSupplier.get().whenComplete(this::complete);
        } else {
            ScheduledFuture<?> scheduledSupply = this.scheduler.schedule(this.innerExecutionSupplier::get, 0L, TimeUnit.NANOSECONDS);
            this.future.injectCancelFn((mayInterrupt, result) -> scheduledSupply.cancel((boolean)mayInterrupt));
        }
    }

    private void complete(ExecutionResult result, Throwable error) {
        if (result == null && error == null) {
            return;
        }
        this.completed = true;
        if (!this.future.isDone()) {
            if (result != null) {
                this.future.completeResult(result);
            } else {
                if (error instanceof CompletionException) {
                    error = error.getCause();
                }
                this.future.completeResult(ExecutionResult.failure(error));
            }
        }
    }
}

