/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.jodah.failsafe;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionContext<R> {
    volatile Duration startTime = Duration.ZERO;
    volatile Duration attemptStartTime = Duration.ZERO;
    AtomicInteger attempts = new AtomicInteger();
    AtomicInteger executions = new AtomicInteger();
    volatile int cancelledIndex;
    volatile R lastResult;
    volatile Throwable lastFailure;

    ExecutionContext() {
    }

    private ExecutionContext(ExecutionContext<R> context) {
        this.startTime = context.startTime;
        this.attemptStartTime = context.attemptStartTime;
        this.attempts = context.attempts;
        this.executions = context.executions;
        this.cancelledIndex = context.cancelledIndex;
        this.lastResult = context.lastResult;
        this.lastFailure = context.lastFailure;
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos(System.nanoTime() - this.startTime.toNanos());
    }

    public int getAttemptCount() {
        return this.attempts.get();
    }

    public <T extends Throwable> T getLastFailure() {
        return (T)this.lastFailure;
    }

    public R getLastResult() {
        return this.lastResult;
    }

    public ExecutionContext<R> copy() {
        return new ExecutionContext<R>(this);
    }

    public String toString() {
        return "ExecutionContext[attempts=" + this.attempts + ", executions=" + this.executions + ", lastResult=" + this.lastResult + ", lastFailure=" + this.lastFailure + ']';
    }
}

