/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.FormatSchema;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.exc.StreamWriteException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.CharacterEscapes;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.Instantiatable;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DatabindException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;

public class ObjectWriter
implements Serializable {
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _generatorFactory;
    protected final GeneratorSettings _generatorSettings;
    protected final Prefetch _prefetch;

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config, JavaType rootType, PrettyPrinter pp) {
        this._config = config;
        this._serializerProvider = mapper._serializerProvider;
        this._serializerFactory = mapper._serializerFactory;
        this._generatorFactory = mapper._jsonFactory;
        GeneratorSettings generatorSettings = this._generatorSettings = pp == null ? GeneratorSettings.empty : new GeneratorSettings(pp, null, null, null);
        this._prefetch = rootType == null ? Prefetch.empty : (rootType.hasRawClass(Object.class) ? Prefetch.empty.forRootType(this, rootType) : Prefetch.empty.forRootType(this, rootType.withStaticTyping()));
    }

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config) {
        this._config = config;
        this._serializerProvider = mapper._serializerProvider;
        this._serializerFactory = mapper._serializerFactory;
        this._generatorFactory = mapper._jsonFactory;
        this._generatorSettings = GeneratorSettings.empty;
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectWriter base, SerializationConfig config, GeneratorSettings genSettings, Prefetch prefetch) {
        this._config = config;
        this._serializerProvider = base._serializerProvider;
        this._serializerFactory = base._serializerFactory;
        this._generatorFactory = base._generatorFactory;
        this._generatorSettings = genSettings;
        this._prefetch = prefetch;
    }

    protected ObjectWriter _new(GeneratorSettings genSettings, Prefetch prefetch) {
        if (this._generatorSettings == genSettings && this._prefetch == prefetch) {
            return this;
        }
        return new ObjectWriter(this, this._config, genSettings, prefetch);
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(this._config.getDefaultPrettyPrinter());
    }

    public ObjectWriter with(PrettyPrinter pp) {
        return this._new(this._generatorSettings.with(pp), this._prefetch);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        this._assertNotNull("out", out);
        return this._configureGenerator(this._generatorFactory.createGenerator(out, enc));
    }

    public JsonGenerator createGenerator(Writer w2) throws IOException {
        this._assertNotNull("w", w2);
        return this._configureGenerator(this._generatorFactory.createGenerator(w2));
    }

    public boolean isEnabled(SerializationFeature f2) {
        return this._config.isEnabled(f2);
    }

    public void writeValue(OutputStream out, Object value) throws IOException, StreamWriteException, DatabindException {
        this._writeValueAndClose(this.createGenerator(out, JsonEncoding.UTF8), value);
    }

    public void writeValue(Writer w2, Object value) throws IOException, StreamWriteException, DatabindException {
        this._writeValueAndClose(this.createGenerator(w2), value);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        SegmentedStringWriter sw = new SegmentedStringWriter(this._generatorFactory._getBufferRecycler());
        try {
            this._writeValueAndClose(this.createGenerator(sw), value);
        }
        catch (JsonProcessingException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw JsonMappingException.fromUnexpectedIOE(e3);
        }
        return sw.getAndClear();
    }

    protected DefaultSerializerProvider _serializerProvider() {
        return this._serializerProvider.createInstance(this._config, this._serializerFactory);
    }

    protected final void _writeValueAndClose(JsonGenerator gen, Object value) throws IOException {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseable(gen, value);
            return;
        }
        try {
            this._prefetch.serialize(gen, value, this._serializerProvider());
        }
        catch (Exception e2) {
            ClassUtil.closeOnFailAndThrowAsIOE(gen, e2);
            return;
        }
        gen.close();
    }

    private final void _writeCloseable(JsonGenerator gen, Object value) throws IOException {
        Closeable toClose = (Closeable)value;
        try {
            this._prefetch.serialize(gen, value, this._serializerProvider());
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        catch (Exception e2) {
            ClassUtil.closeOnFailAndThrowAsIOE(gen, toClose, e2);
            return;
        }
        gen.close();
    }

    protected final JsonGenerator _configureGenerator(JsonGenerator gen) {
        this._config.initialize(gen);
        this._generatorSettings.initialize(gen);
        return gen;
    }

    protected final void _assertNotNull(String paramName, Object src) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", paramName));
        }
    }

    public static final class Prefetch
    implements Serializable {
        public static final Prefetch empty = new Prefetch(null, null, null);
        private final JavaType rootType;
        private final JsonSerializer<Object> valueSerializer;
        private final TypeSerializer typeSerializer;

        private Prefetch(JavaType rootT, JsonSerializer<Object> ser, TypeSerializer typeSer) {
            this.rootType = rootT;
            this.valueSerializer = ser;
            this.typeSerializer = typeSer;
        }

        public Prefetch forRootType(ObjectWriter parent, JavaType newType) {
            if (newType == null) {
                if (this.rootType == null || this.valueSerializer == null) {
                    return this;
                }
                return new Prefetch(null, null, null);
            }
            if (newType.equals(this.rootType)) {
                return this;
            }
            if (newType.isJavaLangObject()) {
                TypeSerializer typeSer;
                DefaultSerializerProvider prov = parent._serializerProvider();
                try {
                    typeSer = prov.findTypeSerializer(newType);
                }
                catch (JsonMappingException e2) {
                    throw new RuntimeJsonMappingException(e2);
                }
                return new Prefetch(null, null, typeSer);
            }
            if (parent.isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
                DefaultSerializerProvider prov = parent._serializerProvider();
                try {
                    JsonSerializer<Object> ser = prov.findTypedValueSerializer(newType, true, null);
                    if (ser instanceof TypeWrappedSerializer) {
                        return new Prefetch(newType, null, ((TypeWrappedSerializer)ser).typeSerializer());
                    }
                    return new Prefetch(newType, ser, null);
                }
                catch (DatabindException databindException) {
                    // empty catch block
                }
            }
            return new Prefetch(newType, null, this.typeSerializer);
        }

        public void serialize(JsonGenerator gen, Object value, DefaultSerializerProvider prov) throws IOException {
            if (this.typeSerializer != null) {
                prov.serializePolymorphic(gen, value, this.rootType, this.valueSerializer, this.typeSerializer);
            } else if (this.valueSerializer != null) {
                prov.serializeValue(gen, value, this.rootType, this.valueSerializer);
            } else if (this.rootType != null) {
                prov.serializeValue(gen, value, this.rootType);
            } else {
                prov.serializeValue(gen, value);
            }
        }
    }

    public static final class GeneratorSettings
    implements Serializable {
        public static final GeneratorSettings empty = new GeneratorSettings(null, null, null, null);
        public final PrettyPrinter prettyPrinter;
        public final FormatSchema schema;
        public final CharacterEscapes characterEscapes;
        public final SerializableString rootValueSeparator;

        public GeneratorSettings(PrettyPrinter pp, FormatSchema sch, CharacterEscapes esc, SerializableString rootSep) {
            this.prettyPrinter = pp;
            this.schema = sch;
            this.characterEscapes = esc;
            this.rootValueSeparator = rootSep;
        }

        public GeneratorSettings with(PrettyPrinter pp) {
            if (pp == null) {
                pp = NULL_PRETTY_PRINTER;
            }
            return pp == this.prettyPrinter ? this : new GeneratorSettings(pp, this.schema, this.characterEscapes, this.rootValueSeparator);
        }

        public void initialize(JsonGenerator gen) {
            PrettyPrinter pp = this.prettyPrinter;
            if (this.prettyPrinter != null) {
                if (pp == NULL_PRETTY_PRINTER) {
                    gen.setPrettyPrinter(null);
                } else {
                    if (pp instanceof Instantiatable) {
                        pp = (PrettyPrinter)((Instantiatable)((Object)pp)).createInstance();
                    }
                    gen.setPrettyPrinter(pp);
                }
            }
            if (this.characterEscapes != null) {
                gen.setCharacterEscapes(this.characterEscapes);
            }
            if (this.schema != null) {
                gen.setSchema(this.schema);
            }
            if (this.rootValueSeparator != null) {
                gen.setRootValueSeparator(this.rootValueSeparator);
            }
        }
    }
}

