/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.client;

import com.gradle.maven.extension.internal.dep.org.apache.http.ConnectionReuseStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.Header;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpHost;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequestInterceptor;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponseInterceptor;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.AuthSchemeProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.AuthenticationStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.BackoffManager;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.ConnectionBackoffStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.CookieStore;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.CredentialsProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.HttpRequestRetryHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.RedirectStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.ServiceUnavailableRetryStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.UserTokenHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.config.RequestConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.entity.InputStreamFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.RequestAcceptEncoding;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.RequestAddCookies;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.RequestAuthCache;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.RequestClientConnControl;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.RequestDefaultHeaders;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.RequestExpectContinue;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.ResponseContentEncoding;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.ResponseProcessCookies;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.ConnectionConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.Lookup;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.Registry;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.RegistryBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.SocketConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.DnsResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.HttpClientConnectionManager;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.SchemePortResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.routing.HttpRoutePlanner;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.PublicSuffixMatcher;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.PublicSuffixMatcherLoader;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.CookieSpecProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.NoConnectionReuseStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.BasicSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.DigestSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.KerberosSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.NTLMSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.SPNegoSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.BasicCookieStore;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.BasicCredentialsProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.CloseableHttpClient;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.CookieSpecRegistries;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.DefaultRedirectStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.DefaultUserTokenHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.IdleConnectionEvictor;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.InternalHttpClient;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.NoopUserTokenHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.ProxyAuthenticationStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.TargetAuthenticationStrategy;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.DefaultRoutePlanner;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.DefaultSchemePortResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.BackoffStrategyExec;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.ClientExecChain;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.MainClientExec;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.ProtocolExec;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.RedirectExec;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.RetryExec;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.execchain.ServiceUnavailableRetryExec;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpProcessor;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpProcessorBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpRequestExecutor;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.ImmutableHttpProcessor;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.RequestContent;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.RequestTargetHost;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.RequestUserAgent;
import com.gradle.maven.extension.internal.dep.org.apache.http.ssl.SSLContexts;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.TextUtils;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.VersionInfo;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class HttpClientBuilder {
    private HttpRequestExecutor requestExec;
    private HostnameVerifier hostnameVerifier;
    private LayeredConnectionSocketFactory sslSocketFactory;
    private SSLContext sslContext;
    private HttpClientConnectionManager connManager;
    private boolean connManagerShared;
    private SchemePortResolver schemePortResolver;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private AuthenticationStrategy targetAuthStrategy;
    private AuthenticationStrategy proxyAuthStrategy;
    private UserTokenHandler userTokenHandler;
    private HttpProcessor httpprocessor;
    private DnsResolver dnsResolver;
    private LinkedList<HttpRequestInterceptor> requestFirst;
    private LinkedList<HttpRequestInterceptor> requestLast;
    private LinkedList<HttpResponseInterceptor> responseFirst;
    private LinkedList<HttpResponseInterceptor> responseLast;
    private HttpRequestRetryHandler retryHandler;
    private HttpRoutePlanner routePlanner;
    private RedirectStrategy redirectStrategy;
    private ConnectionBackoffStrategy connectionBackoffStrategy;
    private BackoffManager backoffManager;
    private ServiceUnavailableRetryStrategy serviceUnavailStrategy;
    private Lookup<AuthSchemeProvider> authSchemeRegistry;
    private Lookup<CookieSpecProvider> cookieSpecRegistry;
    private Map<String, InputStreamFactory> contentDecoderMap;
    private CookieStore cookieStore;
    private CredentialsProvider credentialsProvider;
    private String userAgent;
    private HttpHost proxy;
    private Collection<? extends Header> defaultHeaders;
    private SocketConfig defaultSocketConfig;
    private ConnectionConfig defaultConnectionConfig;
    private RequestConfig defaultRequestConfig;
    private boolean evictExpiredConnections;
    private boolean evictIdleConnections;
    private long maxIdleTime;
    private TimeUnit maxIdleTimeUnit;
    private boolean systemProperties;
    private boolean redirectHandlingDisabled;
    private boolean automaticRetriesDisabled;
    private boolean contentCompressionDisabled;
    private boolean cookieManagementDisabled;
    private boolean authCachingDisabled;
    private boolean connectionStateDisabled;
    private boolean defaultUserAgentDisabled;
    private int maxConnTotal = 0;
    private int maxConnPerRoute = 0;
    private long connTimeToLive = -1L;
    private TimeUnit connTimeToLiveTimeUnit = TimeUnit.MILLISECONDS;
    private List<Closeable> closeables;
    private PublicSuffixMatcher publicSuffixMatcher;

    public static HttpClientBuilder create() {
        return new HttpClientBuilder();
    }

    protected HttpClientBuilder() {
    }

    public final HttpClientBuilder setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public final HttpClientBuilder setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public final HttpClientBuilder setConnectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
        this.connTimeToLive = connTimeToLive;
        this.connTimeToLiveTimeUnit = connTimeToLiveTimeUnit;
        return this;
    }

    public final HttpClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public final HttpClientBuilder addInterceptorLast(HttpResponseInterceptor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.responseLast == null) {
            this.responseLast = new LinkedList();
        }
        this.responseLast.addLast(itcp);
        return this;
    }

    public final HttpClientBuilder addInterceptorFirst(HttpRequestInterceptor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.requestFirst == null) {
            this.requestFirst = new LinkedList();
        }
        this.requestFirst.addFirst(itcp);
        return this;
    }

    public final HttpClientBuilder addInterceptorLast(HttpRequestInterceptor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.requestLast == null) {
            this.requestLast = new LinkedList();
        }
        this.requestLast.addLast(itcp);
        return this;
    }

    public final HttpClientBuilder setRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.retryHandler = retryHandler;
        return this;
    }

    public final HttpClientBuilder setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
        return this;
    }

    public final HttpClientBuilder disableRedirectHandling() {
        this.redirectHandlingDisabled = true;
        return this;
    }

    public final HttpClientBuilder setDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public final HttpClientBuilder setDefaultRequestConfig(RequestConfig config) {
        this.defaultRequestConfig = config;
        return this;
    }

    protected ClientExecChain createMainExec(HttpRequestExecutor requestExec, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, HttpProcessor proxyHttpProcessor, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler) {
        return new MainClientExec(requestExec, connManager, reuseStrategy, keepAliveStrategy, proxyHttpProcessor, targetAuthStrategy, proxyAuthStrategy, userTokenHandler);
    }

    protected ClientExecChain decorateMainExec(ClientExecChain mainExec) {
        return mainExec;
    }

    protected ClientExecChain decorateProtocolExec(ClientExecChain protocolExec) {
        return protocolExec;
    }

    private static String[] split(String s2) {
        if (TextUtils.isBlank(s2)) {
            return null;
        }
        return s2.split(" *, *");
    }

    /*
     * WARNING - void declaration
     */
    public CloseableHttpClient build() {
        void var14_31;
        ArrayList<Closeable> closeablesCopy;
        CredentialsProvider defaultCredentialsProvider;
        CookieStore defaultCookieStore;
        Lookup<CookieSpecProvider> cookieSpecRegistryCopy;
        Lookup<AuthSchemeProvider> lookup;
        ServiceUnavailableRetryStrategy serviceUnavailStrategyCopy;
        HttpRoutePlanner routePlannerCopy;
        String userAgentCopy;
        UserTokenHandler userTokenHandlerCopy;
        AuthenticationStrategy proxyAuthStrategyCopy;
        AuthenticationStrategy targetAuthStrategyCopy;
        ConnectionKeepAliveStrategy keepAliveStrategyCopy;
        ConnectionReuseStrategy reuseStrategyCopy;
        HttpClientConnectionManager connManagerCopy;
        HttpRequestExecutor requestExecCopy;
        PublicSuffixMatcher publicSuffixMatcherCopy = this.publicSuffixMatcher;
        if (publicSuffixMatcherCopy == null) {
            publicSuffixMatcherCopy = PublicSuffixMatcherLoader.getDefault();
        }
        if ((requestExecCopy = this.requestExec) == null) {
            requestExecCopy = new HttpRequestExecutor();
        }
        if ((connManagerCopy = this.connManager) == null) {
            String s2;
            LayeredConnectionSocketFactory sslSocketFactoryCopy = this.sslSocketFactory;
            if (sslSocketFactoryCopy == null) {
                String[] supportedProtocols = this.systemProperties ? HttpClientBuilder.split(System.getProperty("https.protocols")) : null;
                String[] supportedCipherSuites = this.systemProperties ? HttpClientBuilder.split(System.getProperty("https.cipherSuites")) : null;
                HostnameVerifier hostnameVerifierCopy = this.hostnameVerifier;
                if (hostnameVerifierCopy == null) {
                    hostnameVerifierCopy = new DefaultHostnameVerifier(publicSuffixMatcherCopy);
                }
                sslSocketFactoryCopy = this.sslContext != null ? new SSLConnectionSocketFactory(this.sslContext, supportedProtocols, supportedCipherSuites, hostnameVerifierCopy) : (this.systemProperties ? new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), supportedProtocols, supportedCipherSuites, hostnameVerifierCopy) : new SSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifierCopy));
            }
            PoolingHttpClientConnectionManager poolingmgr = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactoryCopy)).build(), null, null, this.dnsResolver, this.connTimeToLive, this.connTimeToLiveTimeUnit != null ? this.connTimeToLiveTimeUnit : TimeUnit.MILLISECONDS);
            if (this.defaultSocketConfig != null) {
                poolingmgr.setDefaultSocketConfig(this.defaultSocketConfig);
            }
            if (this.defaultConnectionConfig != null) {
                poolingmgr.setDefaultConnectionConfig(this.defaultConnectionConfig);
            }
            if (this.systemProperties && "true".equalsIgnoreCase(s2 = System.getProperty("http.keepAlive", "true"))) {
                s2 = System.getProperty("http.maxConnections", "5");
                int max = Integer.parseInt(s2);
                poolingmgr.setDefaultMaxPerRoute(max);
                poolingmgr.setMaxTotal(2 * max);
            }
            if (this.maxConnTotal > 0) {
                poolingmgr.setMaxTotal(this.maxConnTotal);
            }
            if (this.maxConnPerRoute > 0) {
                poolingmgr.setDefaultMaxPerRoute(this.maxConnPerRoute);
            }
            connManagerCopy = poolingmgr;
        }
        if ((reuseStrategyCopy = this.reuseStrategy) == null) {
            String s3;
            reuseStrategyCopy = this.systemProperties ? ("true".equalsIgnoreCase(s3 = System.getProperty("http.keepAlive", "true")) ? DefaultClientConnectionReuseStrategy.INSTANCE : NoConnectionReuseStrategy.INSTANCE) : DefaultClientConnectionReuseStrategy.INSTANCE;
        }
        if ((keepAliveStrategyCopy = this.keepAliveStrategy) == null) {
            keepAliveStrategyCopy = DefaultConnectionKeepAliveStrategy.INSTANCE;
        }
        if ((targetAuthStrategyCopy = this.targetAuthStrategy) == null) {
            targetAuthStrategyCopy = TargetAuthenticationStrategy.INSTANCE;
        }
        if ((proxyAuthStrategyCopy = this.proxyAuthStrategy) == null) {
            proxyAuthStrategyCopy = ProxyAuthenticationStrategy.INSTANCE;
        }
        if ((userTokenHandlerCopy = this.userTokenHandler) == null) {
            userTokenHandlerCopy = !this.connectionStateDisabled ? DefaultUserTokenHandler.INSTANCE : NoopUserTokenHandler.INSTANCE;
        }
        if ((userAgentCopy = this.userAgent) == null) {
            if (this.systemProperties) {
                userAgentCopy = System.getProperty("http.agent");
            }
            if (userAgentCopy == null && !this.defaultUserAgentDisabled) {
                userAgentCopy = VersionInfo.getUserAgent("Apache-HttpClient", "com.gradle.maven.extension.internal.dep.org.apache.http.client", this.getClass());
            }
        }
        ClientExecChain execChain = this.createMainExec(requestExecCopy, connManagerCopy, reuseStrategyCopy, keepAliveStrategyCopy, new ImmutableHttpProcessor(new RequestTargetHost(), new RequestUserAgent(userAgentCopy)), targetAuthStrategyCopy, proxyAuthStrategyCopy, userTokenHandlerCopy);
        execChain = this.decorateMainExec(execChain);
        HttpProcessor httpprocessorCopy = this.httpprocessor;
        if (httpprocessorCopy == null) {
            HttpProcessorBuilder b2 = HttpProcessorBuilder.create();
            if (this.requestFirst != null) {
                for (HttpRequestInterceptor httpRequestInterceptor : this.requestFirst) {
                    b2.addFirst(httpRequestInterceptor);
                }
            }
            if (this.responseFirst != null) {
                for (HttpResponseInterceptor httpResponseInterceptor : this.responseFirst) {
                    b2.addFirst(httpResponseInterceptor);
                }
            }
            b2.addAll(new RequestDefaultHeaders(this.defaultHeaders), new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(userAgentCopy), new RequestExpectContinue());
            if (!this.cookieManagementDisabled) {
                b2.add(new RequestAddCookies());
            }
            if (!this.contentCompressionDisabled) {
                if (this.contentDecoderMap != null) {
                    ArrayList<String> encodings = new ArrayList<String>(this.contentDecoderMap.keySet());
                    Collections.sort(encodings);
                    b2.add(new RequestAcceptEncoding(encodings));
                } else {
                    b2.add(new RequestAcceptEncoding());
                }
            }
            if (!this.authCachingDisabled) {
                b2.add(new RequestAuthCache());
            }
            if (!this.cookieManagementDisabled) {
                b2.add(new ResponseProcessCookies());
            }
            if (!this.contentCompressionDisabled) {
                if (this.contentDecoderMap != null) {
                    RegistryBuilder<InputStreamFactory> b22 = RegistryBuilder.create();
                    for (Map.Entry<String, InputStreamFactory> entry : this.contentDecoderMap.entrySet()) {
                        b22.register(entry.getKey(), entry.getValue());
                    }
                    b2.add(new ResponseContentEncoding(b22.build()));
                } else {
                    b2.add(new ResponseContentEncoding());
                }
            }
            if (this.requestLast != null) {
                for (HttpRequestInterceptor httpRequestInterceptor : this.requestLast) {
                    b2.addLast(httpRequestInterceptor);
                }
            }
            if (this.responseLast != null) {
                for (HttpResponseInterceptor httpResponseInterceptor : this.responseLast) {
                    b2.addLast(httpResponseInterceptor);
                }
            }
            httpprocessorCopy = b2.build();
        }
        execChain = new ProtocolExec(execChain, httpprocessorCopy);
        execChain = this.decorateProtocolExec(execChain);
        if (!this.automaticRetriesDisabled) {
            HttpRequestRetryHandler retryHandlerCopy = this.retryHandler;
            if (retryHandlerCopy == null) {
                retryHandlerCopy = DefaultHttpRequestRetryHandler.INSTANCE;
            }
            execChain = new RetryExec(execChain, retryHandlerCopy);
        }
        if ((routePlannerCopy = this.routePlanner) == null) {
            SchemePortResolver schemePortResolverCopy = this.schemePortResolver;
            if (schemePortResolverCopy == null) {
                schemePortResolverCopy = DefaultSchemePortResolver.INSTANCE;
            }
            routePlannerCopy = this.proxy != null ? new DefaultProxyRoutePlanner(this.proxy, schemePortResolverCopy) : (this.systemProperties ? new SystemDefaultRoutePlanner(schemePortResolverCopy, ProxySelector.getDefault()) : new DefaultRoutePlanner(schemePortResolverCopy));
        }
        if ((serviceUnavailStrategyCopy = this.serviceUnavailStrategy) != null) {
            execChain = new ServiceUnavailableRetryExec(execChain, serviceUnavailStrategyCopy);
        }
        if (!this.redirectHandlingDisabled) {
            void var14_27;
            RedirectStrategy redirectStrategy = this.redirectStrategy;
            if (redirectStrategy == null) {
                DefaultRedirectStrategy defaultRedirectStrategy = DefaultRedirectStrategy.INSTANCE;
            }
            execChain = new RedirectExec(execChain, routePlannerCopy, (RedirectStrategy)var14_27);
        }
        if (this.backoffManager != null && this.connectionBackoffStrategy != null) {
            execChain = new BackoffStrategyExec(execChain, this.connectionBackoffStrategy, this.backoffManager);
        }
        if ((lookup = this.authSchemeRegistry) == null) {
            Registry<BasicSchemeFactory> registry = RegistryBuilder.create().register("Basic", new BasicSchemeFactory()).register("Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory())).register("NTLM", (BasicSchemeFactory)((Object)new NTLMSchemeFactory())).register("Negotiate", (BasicSchemeFactory)((Object)new SPNegoSchemeFactory())).register("Kerberos", (BasicSchemeFactory)((Object)new KerberosSchemeFactory())).build();
        }
        if ((cookieSpecRegistryCopy = this.cookieSpecRegistry) == null) {
            cookieSpecRegistryCopy = CookieSpecRegistries.createDefault(publicSuffixMatcherCopy);
        }
        if ((defaultCookieStore = this.cookieStore) == null) {
            defaultCookieStore = new BasicCookieStore();
        }
        if ((defaultCredentialsProvider = this.credentialsProvider) == null) {
            defaultCredentialsProvider = this.systemProperties ? new SystemDefaultCredentialsProvider() : new BasicCredentialsProvider();
        }
        ArrayList<Closeable> arrayList = closeablesCopy = this.closeables != null ? new ArrayList<Closeable>(this.closeables) : null;
        if (!this.connManagerShared) {
            if (closeablesCopy == null) {
                closeablesCopy = new ArrayList(1);
            }
            final HttpClientConnectionManager cm2 = connManagerCopy;
            if (this.evictExpiredConnections || this.evictIdleConnections) {
                final IdleConnectionEvictor connectionEvictor = new IdleConnectionEvictor(cm2, this.maxIdleTime > 0L ? this.maxIdleTime : 10L, this.maxIdleTimeUnit != null ? this.maxIdleTimeUnit : TimeUnit.SECONDS, this.maxIdleTime, this.maxIdleTimeUnit);
                closeablesCopy.add(new Closeable(){

                    @Override
                    public void close() throws IOException {
                        connectionEvictor.shutdown();
                        try {
                            connectionEvictor.awaitTermination(1L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
                connectionEvictor.start();
            }
            closeablesCopy.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    cm2.shutdown();
                }
            });
        }
        return new InternalHttpClient(execChain, connManagerCopy, routePlannerCopy, cookieSpecRegistryCopy, (Lookup<AuthSchemeProvider>)var14_31, defaultCookieStore, defaultCredentialsProvider, this.defaultRequestConfig != null ? this.defaultRequestConfig : RequestConfig.DEFAULT, closeablesCopy);
    }
}

