/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.jodah.failsafe;

import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.AbstractExecution;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.AsyncExecution;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.ExecutionResult;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.function.CheckedSupplier;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.function.ContextualSupplier;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.internal.util.Assert;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.util.concurrent.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

final class Functions {
    static <R> Supplier<ExecutionResult> get(CheckedSupplier<R> supplier, AbstractExecution<R> execution) {
        return () -> {
            ExecutionResult result;
            Throwable throwable = null;
            try {
                execution.preExecute();
                result = ExecutionResult.success(supplier.get());
            }
            catch (Throwable t2) {
                throwable = t2;
                result = ExecutionResult.failure(t2);
            }
            finally {
                AbstractExecution abstractExecution = execution;
                synchronized (abstractExecution) {
                    execution.canInterrupt = false;
                    if (execution.interrupted) {
                        Thread.interrupted();
                    } else if (throwable instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            execution.record(result);
            return result;
        };
    }

    static <R> Supplier<CompletableFuture<ExecutionResult>> getPromiseAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, AsyncExecution<R> execution) {
        AtomicBoolean scheduled = new AtomicBoolean();
        return () -> {
            if (scheduled.get()) {
                return (CompletableFuture)supplier.get();
            }
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> Functions.lambda$null$3((Supplier)supplier, promise);
            try {
                scheduled.set(true);
                ScheduledFuture<?> scheduledSupply = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                execution.future.injectCancelFn((mayInterrupt, cancelResult) -> {
                    scheduledSupply.cancel((boolean)mayInterrupt);
                    if (!execution.inProgress) {
                        promise.complete(cancelResult);
                    }
                });
            }
            catch (Throwable t2) {
                promise.completeExceptionally(t2);
            }
            return promise;
        };
    }

    static <R> Supplier<CompletableFuture<ExecutionResult>> getPromiseOfStage(ContextualSupplier<R, ? extends CompletionStage<? extends R>> supplier, AsyncExecution<R> execution) {
        Assert.notNull(supplier, "supplier");
        return () -> {
            CompletableFuture<ExecutionResult> promise = new CompletableFuture<ExecutionResult>();
            try {
                execution.preExecute();
                CompletionStage stage = (CompletionStage)supplier.get(execution);
                if (stage instanceof Future) {
                    execution.future.injectStage((Future)((Object)stage));
                }
                stage.whenComplete((result, failure) -> {
                    if (failure instanceof CompletionException) {
                        failure = failure.getCause();
                    }
                    ExecutionResult r2 = failure == null ? ExecutionResult.success(result) : ExecutionResult.failure(failure);
                    execution.record(r2);
                    promise.complete(r2);
                });
            }
            catch (Throwable t2) {
                ExecutionResult result2 = ExecutionResult.failure(t2);
                execution.record(result2);
                promise.complete(result2);
            }
            return promise;
        };
    }

    static <R> SettableSupplier<CompletableFuture<R>> toSettableSupplier(final Supplier<CompletableFuture<R>> supplier) {
        return new SettableSupplier<CompletableFuture<R>>(){
            volatile boolean called;
            volatile CompletableFuture<R> value;

            @Override
            public CompletableFuture<R> get() {
                if (!this.called && this.value != null) {
                    this.called = true;
                    return this.value;
                }
                return (CompletableFuture)supplier.get();
            }
        };
    }

    static <R, T> ContextualSupplier<R, T> toCtxSupplier(CheckedSupplier<T> supplier) {
        Assert.notNull(supplier, "supplier");
        return ctx -> supplier.get();
    }

    private static /* synthetic */ Object lambda$null$3(Supplier supplier, CompletableFuture promise) throws Exception {
        return ((CompletableFuture)supplier.get()).whenComplete((result, error) -> {
            if (error != null) {
                promise.completeExceptionally((Throwable)error);
            } else {
                promise.complete(result);
            }
        });
    }

    static interface SettableSupplier<T>
    extends Supplier<T> {
    }
}

