/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JavaModuleDescriptor {
    private String name;
    private boolean automatic;
    private Set<JavaRequires> requires = new LinkedHashSet<JavaRequires>();
    private Set<JavaExports> exports = new LinkedHashSet<JavaExports>();
    private Set<String> uses = new LinkedHashSet<String>();
    private Set<JavaProvides> provides = new LinkedHashSet<JavaProvides>();

    public String name() {
        return this.name;
    }

    public Set<JavaRequires> requires() {
        return Collections.unmodifiableSet(this.requires);
    }

    public Set<JavaProvides> provides() {
        return Collections.unmodifiableSet(this.provides);
    }

    public Set<String> uses() {
        return Collections.unmodifiableSet(this.uses);
    }

    public static Builder newModule(String name) {
        return new Builder(name).setAutomatic(false);
    }

    public static Builder newAutomaticModule(String name) {
        return new Builder(name).setAutomatic(true);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.automatic, this.requires, this.exports);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaModuleDescriptor other = (JavaModuleDescriptor)obj;
        if (this.automatic != other.automatic) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.requires, other.requires)) {
            return false;
        }
        return Objects.equals(this.exports, other.exports);
    }

    public static class JavaProvides {
        private final String service;
        private final List<String> providers;

        private JavaProvides(String service, List<String> providers) {
            this.service = service;
            this.providers = providers;
        }

        public String service() {
            return this.service;
        }

        public int hashCode() {
            return Objects.hash(this.service, this.providers);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaProvides other = (JavaProvides)obj;
            if (!Objects.equals(this.service, other.service)) {
                return false;
            }
            return Objects.equals(this.providers, other.providers);
        }
    }

    public static class JavaExports {
        private final String source;
        private final Set<String> targets;

        private JavaExports(String source) {
            this.source = source;
            this.targets = null;
        }

        public JavaExports(String source, Set<String> targets) {
            this.source = source;
            this.targets = targets;
        }

        public int hashCode() {
            return Objects.hash(this.source, this.targets);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaExports other = (JavaExports)obj;
            if (!Objects.equals(this.source, other.source)) {
                return false;
            }
            return Objects.equals(this.targets, other.targets);
        }
    }

    public static class JavaRequires {
        private final Set<JavaModifier> modifiers;
        private final String name;

        private JavaRequires(Set<JavaModifier> modifiers, String name) {
            this.modifiers = modifiers;
            this.name = name;
        }

        private JavaRequires(String name) {
            this.modifiers = Collections.emptySet();
            this.name = name;
        }

        public Set<JavaModifier> modifiers() {
            return this.modifiers;
        }

        public String name() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.modifiers, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaRequires other = (JavaRequires)obj;
            if (!Objects.equals(this.modifiers, other.modifiers)) {
                return false;
            }
            return Objects.equals(this.name, other.name);
        }

        public static enum JavaModifier {
            STATIC,
            TRANSITIVE;

        }
    }

    public static final class Builder {
        private JavaModuleDescriptor jModule = new JavaModuleDescriptor();

        private Builder(String name) {
            this.jModule.name = name;
        }

        private Builder setAutomatic(boolean isAutomatic) {
            this.jModule.automatic = isAutomatic;
            return this;
        }

        public Builder requires(Set<JavaRequires.JavaModifier> modifiers, String name) {
            this.jModule.requires.add(new JavaRequires(modifiers, name));
            return this;
        }

        public Builder requires(String name) {
            this.jModule.requires.add(new JavaRequires(name));
            return this;
        }

        public Builder exports(String source) {
            this.jModule.exports.add(new JavaExports(source));
            return this;
        }

        public Builder exports(String source, Set<String> targets) {
            this.jModule.exports.add(new JavaExports(source, targets));
            return this;
        }

        public Builder uses(String service) {
            this.jModule.uses.add(service);
            return this;
        }

        public Builder provides(String service, List<String> providers) {
            this.jModule.provides.add(new JavaProvides(service, providers));
            return this;
        }

        public JavaModuleDescriptor build() {
            return this.jModule;
        }
    }
}

