/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.Nulls;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.exc.StreamReadException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyMetadata;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsAsEmptyProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.AccessPattern;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    @Deprecated
    protected static final int F_MASK_ACCEPT_ARRAYS = DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS.getMask() | DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT.getMask();
    protected final Class<?> _valueClass;
    protected final JavaType _valueType;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
        this._valueType = null;
    }

    protected StdDeserializer(JavaType valueType) {
        this._valueClass = valueType == null ? Object.class : valueType.getRawClass();
        this._valueType = valueType;
    }

    protected StdDeserializer(StdDeserializer<?> src) {
        this._valueClass = src._valueClass;
        this._valueType = src._valueType;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    public JavaType getValueType(DeserializationContext ctxt) {
        if (this._valueType != null) {
            return this._valueType;
        }
        return ctxt.constructType(this._valueClass);
    }

    public ValueInstantiator getValueInstantiator() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deserializer) {
        return ClassUtil.isJacksonStdImpl(deserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeser) {
        return ClassUtil.isJacksonStdImpl(keyDeser);
    }

    @Override
    public Object deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(p2, ctxt);
    }

    protected T _deserializeFromArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        CoercionAction act = this._findCoercionFromEmptyArray(ctxt);
        boolean unwrap = ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (unwrap || act != CoercionAction.Fail) {
            JsonToken t2 = p2.nextToken();
            if (t2 == JsonToken.END_ARRAY) {
                switch (act) {
                    case AsEmpty: {
                        return (T)this.getEmptyValue(ctxt);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return this.getNullValue(ctxt);
                    }
                }
            } else if (unwrap) {
                T parsed = this._deserializeWrappedValue(p2, ctxt);
                if (p2.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p2, ctxt);
                }
                return parsed;
            }
        }
        return (T)ctxt.handleUnexpectedToken(this.getValueType(ctxt), JsonToken.START_ARRAY, p2, null, new Object[0]);
    }

    protected T _deserializeFromString(JsonParser p2, DeserializationContext ctxt) throws IOException {
        ValueInstantiator inst = this.getValueInstantiator();
        Class<?> rawTargetType = this.handledType();
        String value = p2.getValueAsString();
        if (inst != null && inst.canCreateFromString()) {
            return (T)inst.createFromString(ctxt, value);
        }
        if (value.isEmpty()) {
            CoercionAction act = ctxt.findCoercionAction(this.logicalType(), rawTargetType, CoercionInputShape.EmptyString);
            return (T)this._deserializeFromEmptyString(p2, ctxt, act, rawTargetType, "empty String (\"\")");
        }
        if (StdDeserializer._isBlank(value)) {
            CoercionAction act = ctxt.findCoercionFromBlankString(this.logicalType(), rawTargetType, CoercionAction.Fail);
            return (T)this._deserializeFromEmptyString(p2, ctxt, act, rawTargetType, "blank String (all whitespace)");
        }
        if (inst != null) {
            value = value.trim();
            if (inst.canCreateFromInt() && ctxt.findCoercionAction(LogicalType.Integer, Integer.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                return (T)inst.createFromInt(ctxt, this._parseIntPrimitive(ctxt, value));
            }
            if (inst.canCreateFromLong() && ctxt.findCoercionAction(LogicalType.Integer, Long.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                return (T)inst.createFromLong(ctxt, this._parseLongPrimitive(ctxt, value));
            }
            if (inst.canCreateFromBoolean() && ctxt.findCoercionAction(LogicalType.Boolean, Boolean.class, CoercionInputShape.String) == CoercionAction.TryConvert) {
                String str = value.trim();
                if ("true".equals(str)) {
                    return (T)inst.createFromBoolean(ctxt, true);
                }
                if ("false".equals(str)) {
                    return (T)inst.createFromBoolean(ctxt, false);
                }
            }
        }
        return (T)ctxt.handleMissingInstantiator(rawTargetType, inst, ctxt.getParser(), "no String-argument constructor/factory method to deserialize from String value ('%s')", value);
    }

    protected Object _deserializeFromEmptyString(JsonParser p2, DeserializationContext ctxt, CoercionAction act, Class<?> rawTargetType, String desc) throws IOException {
        switch (act) {
            case AsEmpty: {
                return this.getEmptyValue(ctxt);
            }
            case Fail: {
                this._checkCoercionFail(ctxt, act, rawTargetType, "", "empty String (\"\")");
            }
        }
        return null;
    }

    protected T _deserializeWrappedValue(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.START_ARRAY)) {
            String msg = String.format("Cannot deserialize instance of %s out of %s token: nested Arrays not allowed with %s", new Object[]{ClassUtil.nameOf(this._valueClass), JsonToken.START_ARRAY, "DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS"});
            Object result = ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2.currentToken(), p2, msg, new Object[0]);
            return (T)result;
        }
        return this.deserialize(p2, ctxt);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 7: {
                return Boolean.TRUE.equals(this._coerceBooleanFromInt(p2, ctxt, Boolean.TYPE));
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                this._verifyNullForPrimitive(ctxt);
                return false;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, Boolean.TYPE);
                break;
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    p2.nextToken();
                    boolean parsed = this._parseBooleanPrimitive(p2, ctxt);
                    this._verifyEndArrayForSingle(p2, ctxt);
                    return parsed;
                }
            }
            default: {
                return (Boolean)ctxt.handleUnexpectedToken(Boolean.TYPE, p2);
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Boolean, Boolean.TYPE);
        if (act == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(ctxt);
            return false;
        }
        if (act == CoercionAction.AsEmpty) {
            return false;
        }
        int len = (text = text.trim()).length();
        if (len == 4) {
            if (this._isTrue(text)) {
                return true;
            }
        } else if (len == 5 && this._isFalse(text)) {
            return false;
        }
        if (this._hasTextualNull(text)) {
            this._verifyNullForPrimitiveCoercion(ctxt, text);
            return false;
        }
        Boolean b2 = (Boolean)ctxt.handleWeirdStringValue(Boolean.TYPE, text, "only \"true\"/\"True\"/\"TRUE\" or \"false\"/\"False\"/\"FALSE\" recognized", new Object[0]);
        return Boolean.TRUE.equals(b2);
    }

    protected boolean _isTrue(String text) {
        char c2 = text.charAt(0);
        if (c2 == 't') {
            return "true".equals(text);
        }
        if (c2 == 'T') {
            return "TRUE".equals(text) || "True".equals(text);
        }
        return false;
    }

    protected boolean _isFalse(String text) {
        char c2 = text.charAt(0);
        if (c2 == 'f') {
            return "false".equals(text);
        }
        if (c2 == 'F') {
            return "FALSE".equals(text) || "False".equals(text);
        }
        return false;
    }

    protected final Boolean _parseBoolean(JsonParser p2, DeserializationContext ctxt, Class<?> targetType) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 7: {
                return this._coerceBooleanFromInt(p2, ctxt, targetType);
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                return null;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, targetType);
                break;
            }
            case 3: {
                return (Boolean)this._deserializeFromArray(p2, ctxt);
            }
            default: {
                return (Boolean)ctxt.handleUnexpectedToken(targetType, p2);
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Boolean, targetType);
        if (act == CoercionAction.AsNull) {
            return null;
        }
        if (act == CoercionAction.AsEmpty) {
            return false;
        }
        int len = (text = text.trim()).length();
        if (len == 4) {
            if (this._isTrue(text)) {
                return true;
            }
        } else if (len == 5 && this._isFalse(text)) {
            return false;
        }
        if (this._checkTextualNull(ctxt, text)) {
            return null;
        }
        return (Boolean)ctxt.handleWeirdStringValue(targetType, text, "only \"true\" or \"false\" recognized", new Object[0]);
    }

    protected final byte _parseBytePrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        int value;
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 8: {
                CoercionAction act = this._checkFloatToIntCoercion(p2, ctxt, Byte.TYPE);
                if (act == CoercionAction.AsNull) {
                    return 0;
                }
                if (act == CoercionAction.AsEmpty) {
                    return 0;
                }
                return p2.getByteValue();
            }
            case 7: {
                return p2.getByteValue();
            }
            case 11: {
                this._verifyNullForPrimitive(ctxt);
                return 0;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, Byte.TYPE);
                break;
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    p2.nextToken();
                    byte parsed = this._parseBytePrimitive(p2, ctxt);
                    this._verifyEndArrayForSingle(p2, ctxt);
                    return parsed;
                }
            }
            default: {
                return (Byte)ctxt.handleUnexpectedToken(ctxt.constructType(Byte.TYPE), p2);
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Integer, Byte.TYPE);
        if (act == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(ctxt);
            return 0;
        }
        if (act == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull(text = text.trim())) {
            this._verifyNullForPrimitiveCoercion(ctxt, text);
            return 0;
        }
        try {
            value = NumberInput.parseInt(text);
        }
        catch (IllegalArgumentException iae) {
            return (Byte)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid `byte` value", new Object[0]);
        }
        if (this._byteOverflow(value)) {
            return (Byte)ctxt.handleWeirdStringValue(this._valueClass, text, "overflow, value cannot be represented as 8-bit value", new Object[0]);
        }
        return (byte)value;
    }

    protected final short _parseShortPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        int value;
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 8: {
                CoercionAction act = this._checkFloatToIntCoercion(p2, ctxt, Short.TYPE);
                if (act == CoercionAction.AsNull) {
                    return 0;
                }
                if (act == CoercionAction.AsEmpty) {
                    return 0;
                }
                return p2.getShortValue();
            }
            case 7: {
                return p2.getShortValue();
            }
            case 11: {
                this._verifyNullForPrimitive(ctxt);
                return 0;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, Short.TYPE);
                break;
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    p2.nextToken();
                    short parsed = this._parseShortPrimitive(p2, ctxt);
                    this._verifyEndArrayForSingle(p2, ctxt);
                    return parsed;
                }
            }
            default: {
                return (Short)ctxt.handleUnexpectedToken(ctxt.constructType(Short.TYPE), p2);
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Integer, Short.TYPE);
        if (act == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(ctxt);
            return 0;
        }
        if (act == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull(text = text.trim())) {
            this._verifyNullForPrimitiveCoercion(ctxt, text);
            return 0;
        }
        try {
            value = NumberInput.parseInt(text);
        }
        catch (IllegalArgumentException iae) {
            return (Short)ctxt.handleWeirdStringValue(Short.TYPE, text, "not a valid `short` value", new Object[0]);
        }
        if (this._shortOverflow(value)) {
            return (Short)ctxt.handleWeirdStringValue(Short.TYPE, text, "overflow, value cannot be represented as 16-bit value", new Object[0]);
        }
        return (short)value;
    }

    protected final int _parseIntPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 8: {
                CoercionAction act = this._checkFloatToIntCoercion(p2, ctxt, Integer.TYPE);
                if (act == CoercionAction.AsNull) {
                    return 0;
                }
                if (act == CoercionAction.AsEmpty) {
                    return 0;
                }
                return p2.getValueAsInt();
            }
            case 7: {
                return p2.getIntValue();
            }
            case 11: {
                this._verifyNullForPrimitive(ctxt);
                return 0;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, Integer.TYPE);
                break;
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    p2.nextToken();
                    int parsed = this._parseIntPrimitive(p2, ctxt);
                    this._verifyEndArrayForSingle(p2, ctxt);
                    return parsed;
                }
            }
            default: {
                return ((Number)ctxt.handleUnexpectedToken(Integer.TYPE, p2)).intValue();
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Integer, Integer.TYPE);
        if (act == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(ctxt);
            return 0;
        }
        if (act == CoercionAction.AsEmpty) {
            return 0;
        }
        if (this._hasTextualNull(text = text.trim())) {
            this._verifyNullForPrimitiveCoercion(ctxt, text);
            return 0;
        }
        return this._parseIntPrimitive(ctxt, text);
    }

    protected final int _parseIntPrimitive(DeserializationContext ctxt, String text) throws IOException {
        try {
            if (text.length() > 9) {
                long l2 = Long.parseLong(text);
                if (this._intOverflow(l2)) {
                    Number v2 = (Number)ctxt.handleWeirdStringValue(Integer.TYPE, text, "Overflow: numeric value (%s) out of range of int (%d -%d)", text, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    return this._nonNullNumber(v2).intValue();
                }
                return (int)l2;
            }
            return NumberInput.parseInt(text);
        }
        catch (IllegalArgumentException iae) {
            Number v3 = (Number)ctxt.handleWeirdStringValue(Integer.TYPE, text, "not a valid `int` value", new Object[0]);
            return this._nonNullNumber(v3).intValue();
        }
    }

    protected final Integer _parseInteger(JsonParser p2, DeserializationContext ctxt, Class<?> targetType) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 8: {
                CoercionAction act = this._checkFloatToIntCoercion(p2, ctxt, targetType);
                if (act == CoercionAction.AsNull) {
                    return (Integer)this.getNullValue(ctxt);
                }
                if (act == CoercionAction.AsEmpty) {
                    return (Integer)this.getEmptyValue(ctxt);
                }
                return p2.getValueAsInt();
            }
            case 7: {
                return p2.getIntValue();
            }
            case 11: {
                return (Integer)this.getNullValue(ctxt);
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, targetType);
                break;
            }
            case 3: {
                return (Integer)this._deserializeFromArray(p2, ctxt);
            }
            default: {
                return (Integer)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2);
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text);
        if (act == CoercionAction.AsNull) {
            return (Integer)this.getNullValue(ctxt);
        }
        if (act == CoercionAction.AsEmpty) {
            return (Integer)this.getEmptyValue(ctxt);
        }
        if (this._checkTextualNull(ctxt, text = text.trim())) {
            return (Integer)this.getNullValue(ctxt);
        }
        return this._parseIntPrimitive(ctxt, text);
    }

    protected final long _parseLongPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 8: {
                CoercionAction act = this._checkFloatToIntCoercion(p2, ctxt, Long.TYPE);
                if (act == CoercionAction.AsNull) {
                    return 0L;
                }
                if (act == CoercionAction.AsEmpty) {
                    return 0L;
                }
                return p2.getValueAsLong();
            }
            case 7: {
                return p2.getLongValue();
            }
            case 11: {
                this._verifyNullForPrimitive(ctxt);
                return 0L;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, Long.TYPE);
                break;
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    p2.nextToken();
                    long parsed = this._parseLongPrimitive(p2, ctxt);
                    this._verifyEndArrayForSingle(p2, ctxt);
                    return parsed;
                }
            }
            default: {
                return ((Number)ctxt.handleUnexpectedToken(Long.TYPE, p2)).longValue();
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Integer, Long.TYPE);
        if (act == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(ctxt);
            return 0L;
        }
        if (act == CoercionAction.AsEmpty) {
            return 0L;
        }
        if (this._hasTextualNull(text = text.trim())) {
            this._verifyNullForPrimitiveCoercion(ctxt, text);
            return 0L;
        }
        return this._parseLongPrimitive(ctxt, text);
    }

    protected final long _parseLongPrimitive(DeserializationContext ctxt, String text) throws IOException {
        try {
            return NumberInput.parseLong(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number v2 = (Number)ctxt.handleWeirdStringValue(Long.TYPE, text, "not a valid `long` value", new Object[0]);
            return this._nonNullNumber(v2).longValue();
        }
    }

    protected final Long _parseLong(JsonParser p2, DeserializationContext ctxt, Class<?> targetType) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 8: {
                CoercionAction act = this._checkFloatToIntCoercion(p2, ctxt, targetType);
                if (act == CoercionAction.AsNull) {
                    return (Long)this.getNullValue(ctxt);
                }
                if (act == CoercionAction.AsEmpty) {
                    return (Long)this.getEmptyValue(ctxt);
                }
                return p2.getValueAsLong();
            }
            case 11: {
                return (Long)this.getNullValue(ctxt);
            }
            case 7: {
                return p2.getLongValue();
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, targetType);
                break;
            }
            case 3: {
                return (Long)this._deserializeFromArray(p2, ctxt);
            }
            default: {
                return (Long)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2);
            }
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text);
        if (act == CoercionAction.AsNull) {
            return (Long)this.getNullValue(ctxt);
        }
        if (act == CoercionAction.AsEmpty) {
            return (Long)this.getEmptyValue(ctxt);
        }
        if (this._checkTextualNull(ctxt, text = text.trim())) {
            return (Long)this.getNullValue(ctxt);
        }
        return this._parseLongPrimitive(ctxt, text);
    }

    protected final float _parseFloatPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 7: 
            case 8: {
                return p2.getFloatValue();
            }
            case 11: {
                this._verifyNullForPrimitive(ctxt);
                return 0.0f;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, Float.TYPE);
                break;
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    p2.nextToken();
                    float parsed = this._parseFloatPrimitive(p2, ctxt);
                    this._verifyEndArrayForSingle(p2, ctxt);
                    return parsed;
                }
            }
            default: {
                return ((Number)ctxt.handleUnexpectedToken(Float.TYPE, p2)).floatValue();
            }
        }
        Float nan = this._checkFloatSpecialValue(text);
        if (nan != null) {
            return nan.floatValue();
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Integer, Float.TYPE);
        if (act == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(ctxt);
            return 0.0f;
        }
        if (act == CoercionAction.AsEmpty) {
            return 0.0f;
        }
        if (this._hasTextualNull(text = text.trim())) {
            this._verifyNullForPrimitiveCoercion(ctxt, text);
            return 0.0f;
        }
        return this._parseFloatPrimitive(ctxt, text);
    }

    protected final float _parseFloatPrimitive(DeserializationContext ctxt, String text) throws IOException {
        try {
            return Float.parseFloat(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number v2 = (Number)ctxt.handleWeirdStringValue(Float.TYPE, text, "not a valid `float` value", new Object[0]);
            return this._nonNullNumber(v2).floatValue();
        }
    }

    protected Float _checkFloatSpecialValue(String text) {
        if (!text.isEmpty()) {
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
        }
        return null;
    }

    protected final double _parseDoublePrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 7: 
            case 8: {
                return p2.getDoubleValue();
            }
            case 11: {
                this._verifyNullForPrimitive(ctxt);
                return 0.0;
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, Double.TYPE);
                break;
            }
            case 3: {
                if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    p2.nextToken();
                    double parsed = this._parseDoublePrimitive(p2, ctxt);
                    this._verifyEndArrayForSingle(p2, ctxt);
                    return parsed;
                }
            }
            default: {
                return ((Number)ctxt.handleUnexpectedToken(Double.TYPE, p2)).doubleValue();
            }
        }
        Double nan = this._checkDoubleSpecialValue(text);
        if (nan != null) {
            return nan;
        }
        CoercionAction act = this._checkFromStringCoercion(ctxt, text, LogicalType.Integer, Double.TYPE);
        if (act == CoercionAction.AsNull) {
            this._verifyNullForPrimitive(ctxt);
            return 0.0;
        }
        if (act == CoercionAction.AsEmpty) {
            return 0.0;
        }
        if (this._hasTextualNull(text = text.trim())) {
            this._verifyNullForPrimitiveCoercion(ctxt, text);
            return 0.0;
        }
        return this._parseDoublePrimitive(ctxt, text);
    }

    protected final double _parseDoublePrimitive(DeserializationContext ctxt, String text) throws IOException {
        try {
            return StdDeserializer._parseDouble(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Number v2 = (Number)ctxt.handleWeirdStringValue(Double.TYPE, text, "not a valid `double` value (as String to convert)", new Object[0]);
            return this._nonNullNumber(v2).doubleValue();
        }
    }

    protected static final double _parseDouble(String numStr) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(numStr)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(numStr);
    }

    protected Double _checkDoubleSpecialValue(String text) {
        if (!text.isEmpty()) {
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
        }
        return null;
    }

    protected Date _parseDate(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String text;
        switch (p2.currentTokenId()) {
            case 6: {
                text = p2.getText();
                break;
            }
            case 7: {
                long ts;
                try {
                    ts = p2.getLongValue();
                }
                catch (StreamReadException e2) {
                    Number v2 = (Number)ctxt.handleWeirdNumberValue(this._valueClass, p2.getNumberValue(), "not a valid 64-bit `long` for creating `java.util.Date`", new Object[0]);
                    ts = v2.longValue();
                }
                return new Date(ts);
            }
            case 11: {
                return (Date)this.getNullValue(ctxt);
            }
            case 1: {
                text = ctxt.extractScalarFromObject(p2, this, this._valueClass);
                break;
            }
            case 3: {
                return this._parseDateFromArray(p2, ctxt);
            }
            default: {
                return (Date)ctxt.handleUnexpectedToken(this._valueClass, p2);
            }
        }
        return this._parseDate(text.trim(), ctxt);
    }

    protected Date _parseDateFromArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        CoercionAction act = this._findCoercionFromEmptyArray(ctxt);
        boolean unwrap = ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (unwrap || act != CoercionAction.Fail) {
            JsonToken t2 = p2.nextToken();
            if (t2 == JsonToken.END_ARRAY) {
                switch (act) {
                    case AsEmpty: {
                        return (Date)this.getEmptyValue(ctxt);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return (Date)this.getNullValue(ctxt);
                    }
                }
            } else if (unwrap) {
                Date parsed = this._parseDate(p2, ctxt);
                this._verifyEndArrayForSingle(p2, ctxt);
                return parsed;
            }
        }
        return (Date)ctxt.handleUnexpectedToken(this._valueClass, JsonToken.START_ARRAY, p2, null, new Object[0]);
    }

    protected Date _parseDate(String value, DeserializationContext ctxt) throws IOException {
        try {
            if (value.isEmpty()) {
                CoercionAction act = this._checkFromStringCoercion(ctxt, value);
                switch (act) {
                    case AsEmpty: {
                        return new Date(0L);
                    }
                }
                return null;
            }
            if (this._hasTextualNull(value)) {
                return null;
            }
            return ctxt.parseDate(value);
        }
        catch (IllegalArgumentException iae) {
            return (Date)ctxt.handleWeirdStringValue(this._valueClass, value, "not a valid representation (error: %s)", ClassUtil.exceptionMessage(iae));
        }
    }

    protected final String _parseString(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_STRING)) {
            return p2.getText();
        }
        if (p2.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            Object ob = p2.getEmbeddedObject();
            if (ob instanceof byte[]) {
                return ctxt.getBase64Variant().encode((byte[])ob, false);
            }
            if (ob == null) {
                return null;
            }
            return ob.toString();
        }
        if (p2.hasToken(JsonToken.START_OBJECT)) {
            return ctxt.extractScalarFromObject(p2, this, this._valueClass);
        }
        String value = p2.getValueAsString();
        if (value != null) {
            return value;
        }
        return (String)ctxt.handleUnexpectedToken(String.class, p2);
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected final boolean _isNegInf(String text) {
        return "-Infinity".equals(text) || "-INF".equals(text);
    }

    protected final boolean _isPosInf(String text) {
        return "Infinity".equals(text) || "INF".equals(text);
    }

    protected final boolean _isNaN(String text) {
        return "NaN".equals(text);
    }

    protected static final boolean _isBlank(String text) {
        int len = text.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (text.charAt(i2) <= ' ') continue;
            return false;
        }
        return true;
    }

    protected CoercionAction _checkFromStringCoercion(DeserializationContext ctxt, String value) throws IOException {
        return this._checkFromStringCoercion(ctxt, value, this.logicalType(), this.handledType());
    }

    protected CoercionAction _checkFromStringCoercion(DeserializationContext ctxt, String value, LogicalType logicalType, Class<?> rawTargetType) throws IOException {
        if (value.isEmpty()) {
            CoercionAction act = ctxt.findCoercionAction(logicalType, rawTargetType, CoercionInputShape.EmptyString);
            return this._checkCoercionFail(ctxt, act, rawTargetType, value, "empty String (\"\")");
        }
        if (StdDeserializer._isBlank(value)) {
            CoercionAction act = ctxt.findCoercionFromBlankString(logicalType, rawTargetType, CoercionAction.Fail);
            return this._checkCoercionFail(ctxt, act, rawTargetType, value, "blank String (all whitespace)");
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS)) {
            return CoercionAction.TryConvert;
        }
        CoercionAction act = ctxt.findCoercionAction(logicalType, rawTargetType, CoercionInputShape.String);
        if (act == CoercionAction.Fail) {
            ctxt.reportInputMismatch(this, "Cannot coerce String value (\"%s\") to %s (but might if coercion using `CoercionConfig` was enabled)", value, this._coercedTypeDesc());
        }
        return act;
    }

    protected CoercionAction _checkFloatToIntCoercion(JsonParser p2, DeserializationContext ctxt, Class<?> rawTargetType) throws IOException {
        CoercionAction act = ctxt.findCoercionAction(LogicalType.Integer, rawTargetType, CoercionInputShape.Float);
        if (act == CoercionAction.Fail) {
            return this._checkCoercionFail(ctxt, act, rawTargetType, p2.getNumberValue(), "Floating-point value (" + p2.getText() + ")");
        }
        return act;
    }

    protected Boolean _coerceBooleanFromInt(JsonParser p2, DeserializationContext ctxt, Class<?> rawTargetType) throws IOException {
        CoercionAction act = ctxt.findCoercionAction(LogicalType.Boolean, rawTargetType, CoercionInputShape.Integer);
        switch (act) {
            case Fail: {
                this._checkCoercionFail(ctxt, act, rawTargetType, p2.getNumberValue(), "Integer value (" + p2.getText() + ")");
                return Boolean.FALSE;
            }
            case AsNull: {
                return null;
            }
            case AsEmpty: {
                return Boolean.FALSE;
            }
        }
        if (p2.getNumberType() == JsonParser.NumberType.INT) {
            return p2.getIntValue() != 0;
        }
        return !"0".equals(p2.getText());
    }

    protected CoercionAction _checkCoercionFail(DeserializationContext ctxt, CoercionAction act, Class<?> targetType, Object inputValue, String inputDesc) throws IOException {
        if (act == CoercionAction.Fail) {
            ctxt.reportBadCoercion(this, targetType, inputValue, "Cannot coerce %s to %s (but could if coercion was enabled using `CoercionConfig`)", inputDesc, this._coercedTypeDesc());
        }
        return act;
    }

    protected boolean _checkTextualNull(DeserializationContext ctxt, String text) throws JsonMappingException {
        if (this._hasTextualNull(text)) {
            if (!ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                this._reportFailedNullCoerce(ctxt, true, MapperFeature.ALLOW_COERCION_OF_SCALARS, "String \"null\"");
            }
            return true;
        }
        return false;
    }

    protected Object _coerceIntegral(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (ctxt.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
            return p2.getBigIntegerValue();
        }
        if (ctxt.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS)) {
            return p2.getLongValue();
        }
        return p2.getNumberValue();
    }

    protected final void _verifyNullForPrimitive(DeserializationContext ctxt) throws JsonMappingException {
        if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            ctxt.reportInputMismatch(this, "Cannot coerce `null` to %s (disable `DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES` to allow)", this._coercedTypeDesc());
        }
    }

    protected final void _verifyNullForPrimitiveCoercion(DeserializationContext ctxt, String str) throws JsonMappingException {
        boolean enable;
        Enum feat;
        if (!ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            feat = MapperFeature.ALLOW_COERCION_OF_SCALARS;
            enable = true;
        } else if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            feat = DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES;
            enable = false;
        } else {
            return;
        }
        String strDesc = str.isEmpty() ? "empty String (\"\")" : String.format("String \"%s\"", str);
        this._reportFailedNullCoerce(ctxt, enable, feat, strDesc);
    }

    protected void _reportFailedNullCoerce(DeserializationContext ctxt, boolean state, Enum<?> feature, String inputDesc) throws JsonMappingException {
        String enableDesc = state ? "enable" : "disable";
        ctxt.reportInputMismatch(this, "Cannot coerce %s to Null value as %s (%s `%s.%s` to allow)", inputDesc, this._coercedTypeDesc(), enableDesc, feature.getDeclaringClass().getSimpleName(), feature.name());
    }

    protected String _coercedTypeDesc() {
        String typeDesc;
        boolean structured;
        JavaType t2 = this.getValueType();
        if (t2 != null && !t2.isPrimitive()) {
            structured = t2.isContainerType() || t2.isReferenceType();
            typeDesc = ClassUtil.getTypeDescription(t2);
        } else {
            Class<?> cls = this.handledType();
            structured = cls.isArray() || Collection.class.isAssignableFrom(cls) || Map.class.isAssignableFrom(cls);
            typeDesc = ClassUtil.getClassDescription(cls);
        }
        if (structured) {
            return "element of " + typeDesc;
        }
        return typeDesc + " value";
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext ctxt, JavaType type, BeanProperty property) throws JsonMappingException {
        return ctxt.findContextualValueDeserializer(type, property);
    }

    protected final boolean _isIntNumber(String text) {
        int len = text.length();
        if (len > 0) {
            int i2;
            char c2 = text.charAt(0);
            if (c2 == '-' || c2 == '+') {
                if (len == 1) {
                    return false;
                }
                i2 = 1;
            } else {
                i2 = 0;
            }
            while (i2 < len) {
                char ch2 = text.charAt(i2);
                if (ch2 > '9' || ch2 < '0') {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext ctxt, BeanProperty prop, JsonDeserializer<?> existingDeserializer) throws JsonMappingException {
        Object convDef;
        AnnotatedMember member;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (StdDeserializer._neitherNull(intr, prop) && (member = prop.getMember()) != null && (convDef = intr.findDeserializationContentConverter(member)) != null) {
            Converter<Object, Object> conv = ctxt.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
            if (existingDeserializer == null) {
                existingDeserializer = ctxt.findContextualValueDeserializer(delegateType, prop);
            }
            return new StdDelegatingDeserializer<Object>(conv, delegateType, existingDeserializer);
        }
        return existingDeserializer;
    }

    protected JsonFormat.Value findFormatOverrides(DeserializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyFormat(ctxt.getConfig(), typeForDefaults);
        }
        return ctxt.getDefaultPropertyFormat(typeForDefaults);
    }

    protected Boolean findFormatFeature(DeserializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults, JsonFormat.Feature feat) {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, prop, typeForDefaults);
        if (format != null) {
            return format.getFeature(feat);
        }
        return null;
    }

    protected final NullValueProvider findValueNullProvider(DeserializationContext ctxt, SettableBeanProperty prop, PropertyMetadata propMetadata) throws JsonMappingException {
        if (prop != null) {
            return this._findNullProvider(ctxt, prop, propMetadata.getValueNulls(), prop.getValueDeserializer());
        }
        return null;
    }

    protected NullValueProvider findContentNullProvider(DeserializationContext ctxt, BeanProperty prop, JsonDeserializer<?> valueDeser) throws JsonMappingException {
        Nulls nulls = this.findContentNullStyle(ctxt, prop);
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        if (nulls == Nulls.FAIL) {
            if (prop == null) {
                JavaType type = ctxt.constructType(valueDeser.handledType());
                if (type.isContainerType()) {
                    type = type.getContentType();
                }
                return NullsFailProvider.constructForRootValue(type);
            }
            return NullsFailProvider.constructForProperty(prop, prop.getType().getContentType());
        }
        NullValueProvider prov = this._findNullProvider(ctxt, prop, nulls, valueDeser);
        if (prov != null) {
            return prov;
        }
        return valueDeser;
    }

    protected Nulls findContentNullStyle(DeserializationContext ctxt, BeanProperty prop) throws JsonMappingException {
        if (prop != null) {
            return prop.getMetadata().getContentNulls();
        }
        return ctxt.getConfig().getDefaultSetterInfo().getContentNulls();
    }

    protected final NullValueProvider _findNullProvider(DeserializationContext ctxt, BeanProperty prop, Nulls nulls, JsonDeserializer<?> valueDeser) throws JsonMappingException {
        if (nulls == Nulls.FAIL) {
            if (prop == null) {
                Class rawType = valueDeser == null ? Object.class : valueDeser.handledType();
                return NullsFailProvider.constructForRootValue(ctxt.constructType(rawType));
            }
            return NullsFailProvider.constructForProperty(prop);
        }
        if (nulls == Nulls.AS_EMPTY) {
            BeanDeserializerBase bd2;
            ValueInstantiator vi;
            if (valueDeser == null) {
                return null;
            }
            if (valueDeser instanceof BeanDeserializerBase && !(vi = (bd2 = (BeanDeserializerBase)valueDeser).getValueInstantiator()).canCreateUsingDefault()) {
                JavaType type = prop == null ? bd2.getValueType() : prop.getType();
                return (NullValueProvider)ctxt.reportBadDefinition(type, String.format("Cannot create empty instance of %s, no default Creator", type));
            }
            AccessPattern access = valueDeser.getEmptyAccessPattern();
            if (access == AccessPattern.ALWAYS_NULL) {
                return NullsConstantProvider.nuller();
            }
            if (access == AccessPattern.CONSTANT) {
                return NullsConstantProvider.forValue(valueDeser.getEmptyValue(ctxt));
            }
            return new NullsAsEmptyProvider(valueDeser);
        }
        if (nulls == Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        return null;
    }

    protected CoercionAction _findCoercionFromEmptyString(DeserializationContext ctxt) {
        return ctxt.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyString);
    }

    protected CoercionAction _findCoercionFromEmptyArray(DeserializationContext ctxt) {
        return ctxt.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyArray);
    }

    protected CoercionAction _findCoercionFromBlankString(DeserializationContext ctxt) {
        return ctxt.findCoercionFromBlankString(this.logicalType(), this.handledType(), CoercionAction.Fail);
    }

    protected void handleUnknownProperty(JsonParser p2, DeserializationContext ctxt, Object instanceOrClass, String propName) throws IOException {
        if (instanceOrClass == null) {
            instanceOrClass = this.handledType();
        }
        if (ctxt.handleUnknownProperty(p2, this, instanceOrClass, propName)) {
            return;
        }
        p2.skipChildren();
    }

    protected void handleMissingEndArrayForSingle(JsonParser p2, DeserializationContext ctxt) throws IOException {
        ctxt.reportWrongTokenException(this, JsonToken.END_ARRAY, "Attempted to unwrap '%s' value from an array (with `DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS`) but it contains more than one value", this.handledType().getName());
    }

    protected void _verifyEndArrayForSingle(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = p2.nextToken();
        if (t2 != JsonToken.END_ARRAY) {
            this.handleMissingEndArrayForSingle(p2, ctxt);
        }
    }

    protected static final boolean _neitherNull(Object a2, Object b2) {
        return a2 != null && b2 != null;
    }

    protected final boolean _byteOverflow(int value) {
        return value < -128 || value > 255;
    }

    protected final boolean _shortOverflow(int value) {
        return value < Short.MIN_VALUE || value > Short.MAX_VALUE;
    }

    protected final boolean _intOverflow(long value) {
        return value < Integer.MIN_VALUE || value > Integer.MAX_VALUE;
    }

    protected Number _nonNullNumber(Number n2) {
        if (n2 == null) {
            n2 = 0;
        }
        return n2;
    }
}

