/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe;

import com.gradle.maven.extension.internal.dep.dev.failsafe.DelayablePolicyBuilder;
import com.gradle.maven.extension.internal.dep.dev.failsafe.RetryPolicy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.RetryPolicyConfig;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.EventListener;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.ExecutionAttemptedEvent;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.RetryPolicyImpl;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.util.Assert;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.util.Durations;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class RetryPolicyBuilder<R>
extends DelayablePolicyBuilder<RetryPolicyBuilder<R>, RetryPolicyConfig<R>, R> {
    RetryPolicyBuilder() {
        super(new RetryPolicyConfig());
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxRetries = 2;
        ((RetryPolicyConfig)this.config).abortConditions = new ArrayList();
    }

    public RetryPolicy<R> build() {
        return new RetryPolicyImpl(new RetryPolicyConfig((RetryPolicyConfig)this.config));
    }

    public RetryPolicyBuilder<R> abortIf(Predicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.abortOn(Arrays.asList(failure));
    }

    public RetryPolicyBuilder<R> abortOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicyBuilder<R> onFailedAttempt(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).failedAttemptListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetry(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retryListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit, double delayFactor) {
        return this.withBackoff(Duration.of(delay, chronoUnit), Duration.of(maxDelay, chronoUnit), delayFactor);
    }

    public RetryPolicyBuilder<R> withBackoff(Duration delay, Duration maxDelay, double delayFactor) {
        Assert.notNull(delay, "delay");
        Assert.notNull(maxDelay, "maxDelay");
        delay = Durations.ofSafeNanos(delay);
        maxDelay = Durations.ofSafeNanos(maxDelay);
        Assert.isTrue(!delay.isNegative() && !delay.isZero(), "The delay must be > 0", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delay.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || delay.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delay must be >= the jitter duration", new Object[0]);
        Assert.isTrue(delay.toNanos() < maxDelay.toNanos(), "delay must be < the maxDelay", new Object[0]);
        Assert.isTrue(delayFactor > 1.0, "delayFactor must be > 1", new Object[0]);
        ((RetryPolicyConfig)this.config).delay = delay;
        ((RetryPolicyConfig)this.config).maxDelay = maxDelay;
        ((RetryPolicyConfig)this.config).delayFactor = delayFactor;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    @Override
    public RetryPolicyBuilder<R> withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        delay = Durations.ofSafeNanos(delay);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delay.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || delay.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delay must be >= the jitter duration", new Object[0]);
        super.withDelay(delay);
        ((RetryPolicyConfig)this.config).maxDelay = null;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(double jitterFactor) {
        Assert.isTrue(jitterFactor >= 0.0 && jitterFactor <= 1.0, "jitterFactor must be >= 0 and <= 1", new Object[0]);
        ((RetryPolicyConfig)this.config).jitterFactor = jitterFactor;
        ((RetryPolicyConfig)this.config).jitter = null;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxAttempts(int maxAttempts) {
        Assert.isTrue(maxAttempts != 0, "maxAttempts cannot be 0", new Object[0]);
        Assert.isTrue(maxAttempts >= -1, "maxAttempts must be >= -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = maxAttempts == -1 ? -1 : maxAttempts - 1;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxDuration(Duration maxDuration) {
        Assert.notNull(maxDuration, "maxDuration");
        maxDuration = Durations.ofSafeNanos(maxDuration);
        Assert.state(maxDuration.toNanos() > ((RetryPolicyConfig)this.config).delay.toNanos(), "maxDuration must be > the delay", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delayMax == null || maxDuration.toNanos() > ((RetryPolicyConfig)this.config).delayMax.toNanos(), "maxDuration must be > the max random delay", new Object[0]);
        ((RetryPolicyConfig)this.config).maxDuration = maxDuration;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be >= to -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = maxRetries;
        return this;
    }
}

