/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.output;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOConsumer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOFunction;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.output.NullOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThresholdingOutputStream
extends OutputStream {
    private static final IOFunction<ThresholdingOutputStream, OutputStream> NOOP_OS_GETTER = os -> NullOutputStream.NULL_OUTPUT_STREAM;
    private final int threshold;
    private final IOConsumer<ThresholdingOutputStream> thresholdConsumer;
    private final IOFunction<ThresholdingOutputStream, OutputStream> outputStreamGetter;
    private long written;
    private boolean thresholdExceeded;

    public ThresholdingOutputStream(int threshold, IOConsumer<ThresholdingOutputStream> thresholdConsumer, IOFunction<ThresholdingOutputStream, OutputStream> outputStreamGetter) {
        this.threshold = threshold;
        this.thresholdConsumer = thresholdConsumer == null ? IOConsumer.noop() : thresholdConsumer;
        this.outputStreamGetter = outputStreamGetter == null ? NOOP_OS_GETTER : outputStreamGetter;
    }

    protected void checkThreshold(int count) throws IOException {
        if (!this.thresholdExceeded && this.written + (long)count > (long)this.threshold) {
            this.thresholdExceeded = true;
            this.thresholdReached();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    @Override
    public void flush() throws IOException {
        this.getStream().flush();
    }

    protected OutputStream getStream() throws IOException {
        return this.outputStreamGetter.apply(this);
    }

    protected void thresholdReached() throws IOException {
        this.thresholdConsumer.accept(this);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.checkThreshold(b2.length);
        this.getStream().write(b2);
        this.written += (long)b2.length;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.checkThreshold(len);
        this.getStream().write(b2, off, len);
        this.written += (long)len;
    }

    @Override
    public void write(int b2) throws IOException {
        this.checkThreshold(1);
        this.getStream().write(b2);
        ++this.written;
    }
}

