/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.KryoException;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.Output;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers.ImmutableSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

public class RecordSerializer<T>
extends ImmutableSerializer<T> {
    private static final Method IS_RECORD;
    private static final Method GET_RECORD_COMPONENTS;
    private static final Method GET_NAME;
    private static final Method GET_TYPE;
    private boolean fixedFieldTypes = false;

    @Override
    public void write(Kryo kryo, Output output, T object) {
        Class<?> cls = object.getClass();
        if (!this.isRecord(cls)) {
            throw new KryoException(object + " is not a record");
        }
        for (RecordComponent rc : RecordSerializer.recordComponents(cls, Comparator.comparing(RecordComponent::name))) {
            Class<?> type = rc.type();
            String name = rc.name();
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write property: " + name + " (" + type.getName() + ")");
                }
                if (type.isPrimitive()) {
                    kryo.writeObject(output, RecordSerializer.componentValue(object, rc));
                    continue;
                }
                if (this.fixedFieldTypes || kryo.isFinal(type)) {
                    kryo.writeObjectOrNull(output, RecordSerializer.componentValue(object, rc), type);
                    continue;
                }
                kryo.writeClassAndObject(output, RecordSerializer.componentValue(object, rc));
            }
            catch (KryoException ex) {
                ex.addTrace(name + " (" + type.getName() + ")");
                throw ex;
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(name + " (" + type.getName() + ")");
                throw ex;
            }
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        if (!this.isRecord(type)) {
            throw new KryoException("Not a record (" + type + ")");
        }
        RecordComponent[] recordComponents = RecordSerializer.recordComponents(type, Comparator.comparing(RecordComponent::name));
        Object[] values = new Object[recordComponents.length];
        for (int i2 = 0; i2 < recordComponents.length; ++i2) {
            RecordComponent rc = recordComponents[i2];
            String name = rc.name();
            Class<?> rcType = rc.type();
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Read property: " + name + " (" + type.getName() + ")");
                }
                if (rcType.isPrimitive()) {
                    values[rc.index()] = kryo.readObject(input, rcType);
                    continue;
                }
                if (this.fixedFieldTypes || kryo.isFinal(rcType)) {
                    values[rc.index()] = kryo.readObjectOrNull(input, rcType);
                    continue;
                }
                values[rc.index()] = kryo.readClassAndObject(input);
                continue;
            }
            catch (KryoException ex) {
                ex.addTrace(name + " (" + type.getName() + ")");
                throw ex;
            }
            catch (Throwable t2) {
                KryoException ex = new KryoException(t2);
                ex.addTrace(name + " (" + type.getName() + ")");
                throw ex;
            }
        }
        Arrays.sort(recordComponents, Comparator.comparing(RecordComponent::index));
        return RecordSerializer.invokeCanonicalConstructor(type, recordComponents, values);
    }

    private boolean isRecord(Class<?> type) {
        try {
            return (Boolean)IS_RECORD.invoke(type, new Object[0]);
        }
        catch (Throwable t2) {
            throw new KryoException("Could not determine type (" + type + ")");
        }
    }

    private static <T> RecordComponent[] recordComponents(Class<T> type, Comparator<RecordComponent> comparator) {
        try {
            Object[] rawComponents = (Object[])GET_RECORD_COMPONENTS.invoke(type, new Object[0]);
            RecordComponent[] recordComponents = new RecordComponent[rawComponents.length];
            for (int i2 = 0; i2 < rawComponents.length; ++i2) {
                Object comp = rawComponents[i2];
                recordComponents[i2] = new RecordComponent((String)GET_NAME.invoke(comp, new Object[0]), (Class)GET_TYPE.invoke(comp, new Object[0]), i2);
            }
            if (comparator != null) {
                Arrays.sort(recordComponents, comparator);
            }
            return recordComponents;
        }
        catch (Throwable t2) {
            KryoException ex = new KryoException(t2);
            ex.addTrace("Could not retrieve record components (" + type.getName() + ")");
            throw ex;
        }
    }

    private static Object componentValue(Object recordObject, RecordComponent recordComponent) {
        try {
            Method get = recordObject.getClass().getDeclaredMethod(recordComponent.name(), new Class[0]);
            if (!get.canAccess(recordObject)) {
                get.setAccessible(true);
            }
            return get.invoke(recordObject, new Object[0]);
        }
        catch (Throwable t2) {
            KryoException ex = new KryoException(t2);
            ex.addTrace("Could not retrieve record components (" + recordObject.getClass().getName() + ")");
            throw ex;
        }
    }

    private static <T> T invokeCanonicalConstructor(Class<T> recordType, RecordComponent[] recordComponents, Object[] args) {
        try {
            Constructor<T> canonicalConstructor;
            Class[] paramTypes = (Class[])Arrays.stream(recordComponents).map(RecordComponent::type).toArray(Class[]::new);
            try {
                canonicalConstructor = recordType.getConstructor(paramTypes);
            }
            catch (NoSuchMethodException e2) {
                canonicalConstructor = recordType.getDeclaredConstructor(paramTypes);
                canonicalConstructor.setAccessible(true);
            }
            return canonicalConstructor.newInstance(args);
        }
        catch (Throwable t2) {
            KryoException ex = new KryoException(t2);
            ex.addTrace("Could not construct type (" + recordType.getName() + ")");
            throw ex;
        }
    }

    static {
        Method getType;
        Method getName;
        Method getRecordComponents;
        Method isRecord;
        try {
            Class<?> c2 = Class.forName("java.lang.reflect.RecordComponent");
            isRecord = Class.class.getDeclaredMethod("isRecord", new Class[0]);
            getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
            getName = c2.getMethod("getName", new Class[0]);
            getType = c2.getMethod("getType", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e2) {
            isRecord = null;
            getRecordComponents = null;
            getName = null;
            getType = null;
        }
        IS_RECORD = isRecord;
        GET_RECORD_COMPONENTS = getRecordComponents;
        GET_NAME = getName;
        GET_TYPE = getType;
    }

    static final class RecordComponent {
        private final String name;
        private final Class<?> type;
        private final int index;

        RecordComponent(String name, Class<?> type, int index) {
            this.name = name;
            this.type = type;
            this.index = index;
        }

        String name() {
            return this.name;
        }

        Class<?> type() {
            return this.type;
        }

        int index() {
            return this.index;
        }
    }
}

