/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.KryoException;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectIntMap<K>
implements Iterable<Entry<K>> {
    public int size;
    K[] keyTable;
    int[] valueTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;

    public ObjectIntMap() {
        this(51, 0.8f);
    }

    public ObjectIntMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.valueTable = new int[tableSize];
    }

    protected int place(K item) {
        return (int)((long)item.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] keyTable = this.keyTable;
        int i2 = this.place(key);
        K other;
        while ((other = keyTable[i2]) != null) {
            if (other.equals(key)) {
                return i2;
            }
            i2 = i2 + 1 & this.mask;
        }
        return -(i2 + 1);
    }

    public void put(K key, int value) {
        int i2 = this.locateKey(key);
        if (i2 >= 0) {
            this.valueTable[i2] = value;
            return;
        }
        i2 = -(i2 + 1);
        this.keyTable[i2] = key;
        this.valueTable[i2] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
    }

    private void putResize(K key, int value) {
        K[] keyTable = this.keyTable;
        int i2 = this.place(key);
        while (true) {
            if (keyTable[i2] == null) {
                keyTable[i2] = key;
                this.valueTable[i2] = value;
                return;
            }
            i2 = i2 + 1 & this.mask;
        }
    }

    public int get(K key, int defaultValue) {
        int i2 = this.locateKey(key);
        return i2 < 0 ? defaultValue : this.valueTable[i2];
    }

    public void clear(int maximumCapacity) {
        int tableSize = ObjectMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    public boolean containsKey(K key) {
        return this.locateKey(key) >= 0;
    }

    final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] oldKeyTable = this.keyTable;
        int[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize];
        this.valueTable = new int[newSize];
        if (this.size > 0) {
            for (int i2 = 0; i2 < oldCapacity; ++i2) {
                K key = oldKeyTable[i2];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i2]);
            }
        }
    }

    public int hashCode() {
        int h2 = this.size;
        K[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n2 = keyTable.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            K key = keyTable[i2];
            if (key == null) continue;
            h2 += key.hashCode() + valueTable[i2];
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectIntMap)) {
            return false;
        }
        ObjectIntMap other = (ObjectIntMap)obj;
        if (other.size != this.size) {
            return false;
        }
        K[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n2 = keyTable.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            K key = keyTable[i2];
            if (key == null) continue;
            int otherValue = other.get(key, 0);
            if (otherValue == 0 && !other.containsKey(key)) {
                return false;
            }
            if (otherValue == valueTable[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String separator, boolean braces) {
        K key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        K[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int i2 = keyTable.length;
        while (i2-- > 0) {
            key = keyTable[i2];
            if (key == null) continue;
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i2]);
            break;
        }
        while (i2-- > 0) {
            key = keyTable[i2];
            if (key == null) continue;
            buffer.append(separator);
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i2]);
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    @Override
    public Entries<K> iterator() {
        return this.entries();
    }

    public Entries<K> entries() {
        return new Entries(this);
    }

    public static class Entries<K>
    extends MapIterator<K>
    implements Iterable<Entry<K>>,
    Iterator<Entry<K>> {
        Entry<K> entry = new Entry();

        public Entries(ObjectIntMap<K> map) {
            super(map);
        }

        @Override
        public Entry<K> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new KryoException("#iterator() cannot be used nested.");
            }
            K[] keyTable = this.map.keyTable;
            this.entry.key = keyTable[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new KryoException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Entries<K> iterator() {
            return this;
        }
    }

    private static class MapIterator<K> {
        public boolean hasNext;
        final ObjectIntMap<K> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(ObjectIntMap<K> map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            K[] keyTable = this.map.keyTable;
            int n2 = keyTable.length;
            while (++this.nextIndex < n2) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        public void remove() {
            Object key;
            int i2 = this.currentIndex;
            if (i2 < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            K[] keyTable = this.map.keyTable;
            int[] valueTable = this.map.valueTable;
            int mask = this.map.mask;
            int next = i2 + 1 & mask;
            while ((key = keyTable[next]) != null) {
                int placement = this.map.place(key);
                if ((next - placement & mask) > (i2 - placement & mask)) {
                    keyTable[i2] = key;
                    valueTable[i2] = valueTable[next];
                    i2 = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i2] = null;
            --this.map.size;
            if (i2 != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }
    }

    public static class Entry<K> {
        public K key;
        public int value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

