/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ArrayNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.BinaryNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.BooleanNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.DecimalNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.DoubleNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.FloatNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.IntNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.LongNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.NullNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.NumericNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.POJONode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.TextNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ValueNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.RawValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory
implements Serializable {
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bigDecimalExact) {
        this._cfgBigDecimalExact = bigDecimalExact;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public BooleanNode booleanNode(boolean v2) {
        return v2 ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(int v2) {
        return IntNode.valueOf(v2);
    }

    public NumericNode numberNode(long v2) {
        return LongNode.valueOf(v2);
    }

    public ValueNode numberNode(BigInteger v2) {
        if (v2 == null) {
            return this.nullNode();
        }
        return BigIntegerNode.valueOf(v2);
    }

    public NumericNode numberNode(float v2) {
        return FloatNode.valueOf(v2);
    }

    public NumericNode numberNode(double v2) {
        return DoubleNode.valueOf(v2);
    }

    public ValueNode numberNode(BigDecimal v2) {
        if (v2 == null) {
            return this.nullNode();
        }
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(v2);
        }
        if (v2.signum() == 0) {
            return DecimalNode.ZERO;
        }
        try {
            v2 = v2.stripTrailingZeros();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return DecimalNode.valueOf(v2);
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public ValueNode pojoNode(Object pojo) {
        return new POJONode(pojo);
    }

    public ValueNode rawValueNode(RawValue value) {
        return new POJONode(value);
    }
}

