/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.Builder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ErrorHandler;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.JavaClassContext;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.JavaLexer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.ParseException;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl.Parser;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;

public class SourceLibrary
extends AbstractClassLibrary {
    private JavaClassContext context = new JavaClassContext();
    private boolean debugLexer;
    private boolean debugParser;
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private ErrorHandler errorHandler;

    public SourceLibrary(AbstractClassLibrary parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Builder parse(Reader reader, URL url) throws ParseException {
        try {
            Builder builder = this.parse(new JFlexLexer(reader), url);
            return builder;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Builder parse(JavaLexer lexer, URL url) throws ParseException {
        Builder builder = this.getModelBuilder();
        builder.setUrl(url);
        Parser parser = new Parser(lexer, builder);
        parser.setDebugLexer(this.debugLexer);
        parser.setDebugParser(this.debugParser);
        try {
            if (parser.parse()) {
                return builder;
            }
        }
        catch (ParseException pe) {
            if (url != null) {
                pe.setSourceInfo(url.toExternalForm());
            }
            if (this.errorHandler != null) {
                this.errorHandler.handle(pe);
            }
            throw pe;
        }
        return null;
    }

    @Override
    protected JavaClass resolveJavaClass(String name) {
        return this.context.removeClassByName(name);
    }

    @Override
    protected JavaPackage resolveJavaPackage(String name) {
        return this.context.removePackageByName(name);
    }

    @Override
    protected boolean containsClassReference(String name) {
        return this.context.getClassByName(name) != null;
    }
}

