/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe.internal;

import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.EventListener;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.ExecutionAttemptedEvent;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.ExecutionCompletedEvent;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.ExecutionScheduledEvent;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import java.time.Duration;

public interface EventHandler<R> {
    public void handle(ExecutionResult<R> var1, ExecutionContext<R> var2);

    public static <R> EventHandler<R> ofExecutionCompleted(EventListener<ExecutionCompletedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionCompletedEvent(result.getResult(), result.getFailure(), context));
    }

    public static <R> EventHandler<R> ofExecutionAttempted(EventListener<ExecutionAttemptedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionAttemptedEvent(result.getResult(), result.getFailure(), context));
    }

    public static <R> EventHandler<R> ofExecutionScheduled(EventListener<ExecutionScheduledEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionScheduledEvent(result.getResult(), result.getFailure(), Duration.ofNanos(result.getDelay()), context));
    }
}

