/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe.spi;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class ExecutionResult<R> {
    private static final CompletableFuture<?> NULL_FUTURE = CompletableFuture.completedFuture(null);
    private static final ExecutionResult<?> NONE = new ExecutionResult<Object>(null, null, true, 0L, true, true, true);
    private final R result;
    private final Throwable failure;
    private final boolean nonResult;
    private final long delayNanos;
    private final boolean complete;
    private final boolean success;
    private final Boolean successAll;

    private ExecutionResult(R result, Throwable failure, boolean nonResult, long delayNanos, boolean complete, boolean success, Boolean successAll) {
        this.nonResult = nonResult;
        this.result = result;
        this.failure = failure;
        this.delayNanos = delayNanos;
        this.complete = complete;
        this.success = success;
        this.successAll = successAll;
    }

    public static <R> CompletableFuture<ExecutionResult<R>> nullFuture() {
        return NULL_FUTURE;
    }

    public static <R> ExecutionResult<R> success(R result) {
        return new ExecutionResult<R>(result, null, false, 0L, true, true, true);
    }

    public static <R> ExecutionResult<R> failure(Throwable failure) {
        return new ExecutionResult<Object>(null, failure, false, 0L, true, false, false);
    }

    public R getResult() {
        return this.result;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public long getDelay() {
        return this.delayNanos;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isNonResult() {
        return this.nonResult;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ExecutionResult<R> withNotComplete() {
        return !this.complete ? this : new ExecutionResult<R>(this.result, this.failure, this.nonResult, this.delayNanos, false, this.success, this.successAll);
    }

    public ExecutionResult<R> withFailure() {
        return !this.success ? this : new ExecutionResult<R>(this.result, this.failure, this.nonResult, this.delayNanos, this.complete, false, false);
    }

    public ExecutionResult<R> withSuccess() {
        return this.complete && this.success ? this : new ExecutionResult<R>(this.result, this.failure, this.nonResult, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> with(long delayNanos, boolean complete, boolean success) {
        return this.delayNanos == delayNanos && this.complete == complete && this.success == success ? this : new ExecutionResult<R>(this.result, this.failure, this.nonResult, delayNanos, complete, success, this.successAll == null ? success : success && this.successAll != false);
    }

    public boolean getSuccessAll() {
        return this.successAll != null && this.successAll != false;
    }

    public String toString() {
        return "[result=" + this.result + ", failure=" + this.failure + ", nonResult=" + this.nonResult + ", delayNanos=" + this.delayNanos + ", complete=" + this.complete + ", success=" + this.success + ", successAll=" + this.successAll + ']';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ExecutionResult that = (ExecutionResult)o2;
        return Objects.equals(this.result, that.result) && Objects.equals(this.failure, that.failure);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.failure);
    }
}

