/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.AbstractFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrFileFilter
extends AbstractFileFilter
implements Serializable {
    private final List<IOFileFilter> fileFilters;

    public OrFileFilter() {
        this(0);
    }

    private OrFileFilter(ArrayList<IOFileFilter> initialList) {
        this.fileFilters = Objects.requireNonNull(initialList, "initialList");
    }

    private OrFileFilter(int initialCapacity) {
        this(new ArrayList<IOFileFilter>(initialCapacity));
    }

    public OrFileFilter(IOFileFilter filter1, IOFileFilter filter2) {
        this(2);
        this.addFileFilter(filter1);
        this.addFileFilter(filter2);
    }

    @Override
    public boolean accept(File file) {
        for (IOFileFilter fileFilter : this.fileFilters) {
            if (!fileFilter.accept(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String name) {
        for (IOFileFilter fileFilter : this.fileFilters) {
            if (!fileFilter.accept(file, name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileVisitResult accept(Path file, BasicFileAttributes attributes) {
        for (IOFileFilter fileFilter : this.fileFilters) {
            if (fileFilter.accept(file, attributes) != FileVisitResult.CONTINUE) continue;
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.TERMINATE;
    }

    public void addFileFilter(IOFileFilter fileFilter) {
        this.fileFilters.add(Objects.requireNonNull(fileFilter, "fileFilter"));
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.fileFilters != null) {
            for (int i2 = 0; i2 < this.fileFilters.size(); ++i2) {
                if (i2 > 0) {
                    buffer.append(",");
                }
                buffer.append(this.fileFilters.get(i2));
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

