/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.PlexusResource;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.ResourceManager;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.ResourceLoader;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultResourceManager
implements ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceManager.class);
    private final Map<String, ResourceLoader> resourceLoaders;
    private File outputDirectory;

    @Inject
    private DefaultResourceManager(Map<String, ResourceLoader> resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void addSearchPath(String id, String path) {
        ResourceLoader loader = this.resourceLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("unknown resource loader: " + id);
        }
        loader.addSearchPath(path);
    }

    @Override
    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            try {
                PlexusResource resource = resourceLoader.getResource(name);
                LOGGER.debug("The resource '{}' was found as '{}'", (Object)name, (Object)resource.getName());
                return resource;
            }
            catch (ResourceNotFoundException e2) {
                LOGGER.debug("The resource '{}' was not found with resourceLoader '{}'", (Object)name, (Object)resourceLoader.getClass().getName());
            }
        }
        throw new ResourceNotFoundException(name);
    }
}

