/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.QuotedCSV;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ArrayTernaryTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Trie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class HttpFields
implements Iterable<HttpField> {
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    private HttpField[] _fields;
    private int _size;
    @Deprecated
    private static final Float __one = new Float("1.0");
    @Deprecated
    private static final Float __zero = new Float("0.0");
    @Deprecated
    private static final Trie<Float> __qualities = new ArrayTernaryTrie<Float>();

    public HttpFields() {
        this(16);
    }

    public HttpFields(int capacity) {
        this._fields = new HttpField[capacity];
    }

    public int size() {
        return this._size;
    }

    @Override
    public Iterator<HttpField> iterator() {
        return new ListItr();
    }

    public HttpField getField(int index) {
        if (index >= this._size) {
            throw new NoSuchElementException();
        }
        return this._fields[index];
    }

    public HttpField getField(HttpHeader header) {
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField f2 = this._fields[i2];
            if (f2.getHeader() != header) continue;
            return f2;
        }
        return null;
    }

    public HttpField getField(String name) {
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField f2 = this._fields[i2];
            if (!f2.is(name)) continue;
            return f2;
        }
        return null;
    }

    public boolean contains(HttpHeader header, String value) {
        int i2 = this._size;
        while (i2-- > 0) {
            HttpField f2 = this._fields[i2];
            if (f2.getHeader() != header || !f2.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name, String value) {
        int i2 = this._size;
        while (i2-- > 0) {
            HttpField f2 = this._fields[i2];
            if (!f2.is(name) || !f2.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader header) {
        int i2 = this._size;
        while (i2-- > 0) {
            HttpField f2 = this._fields[i2];
            if (f2.getHeader() != header) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String name) {
        int i2 = this._size;
        while (i2-- > 0) {
            HttpField f2 = this._fields[i2];
            if (!f2.is(name)) continue;
            return true;
        }
        return false;
    }

    public String get(HttpHeader header) {
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField f2 = this._fields[i2];
            if (f2.getHeader() != header) continue;
            return f2.getValue();
        }
        return null;
    }

    public String get(String header) {
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField f2 = this._fields[i2];
            if (!f2.is(header)) continue;
            return f2.getValue();
        }
        return null;
    }

    public List<String> getValuesList(HttpHeader header) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField f2 = this._fields[i2];
            if (f2.getHeader() != header) continue;
            list.add(f2.getValue());
        }
        return list;
    }

    public List<String> getCSV(String name, boolean keepQuotes) {
        QuotedCSV values = null;
        for (HttpField f2 : this) {
            if (!f2.is(name)) continue;
            if (values == null) {
                values = new QuotedCSV(keepQuotes, new String[0]);
            }
            values.addValue(f2.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    public void put(HttpField field) {
        boolean put = false;
        int i2 = this._size;
        while (i2-- > 0) {
            HttpField f2 = this._fields[i2];
            if (!f2.isSameName(field)) continue;
            if (put) {
                --this._size;
                System.arraycopy(this._fields, i2 + 1, this._fields, i2, this._size - i2);
                continue;
            }
            this._fields[i2] = field;
            put = true;
        }
        if (!put) {
            this.add(field);
        }
    }

    public void put(HttpHeader header, HttpHeaderValue value) {
        this.put(header, value.toString());
    }

    public void put(HttpHeader header, String value) {
        Objects.requireNonNull(header, "header must not be null");
        if (value == null) {
            this.remove(header);
        } else {
            this.put(new HttpField(header, value));
        }
    }

    public void add(String name, String value) {
        if (value == null) {
            return;
        }
        HttpField field = new HttpField(name, value);
        this.add(field);
    }

    public void add(HttpHeader header, String value) {
        Objects.requireNonNull(header, "header must not be null");
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField field = new HttpField(header, value);
        this.add(field);
    }

    public HttpField remove(HttpHeader name) {
        HttpField removed = null;
        int i2 = this._size;
        while (i2-- > 0) {
            HttpField f2 = this._fields[i2];
            if (f2.getHeader() != name) continue;
            removed = f2;
            this.remove(i2);
        }
        return removed;
    }

    public HttpField remove(String name) {
        HttpField removed = null;
        int i2 = this._size;
        while (i2-- > 0) {
            HttpField f2 = this._fields[i2];
            if (!f2.is(name)) continue;
            removed = f2;
            this.remove(i2);
        }
        return removed;
    }

    private void remove(int i2) {
        --this._size;
        System.arraycopy(this._fields, i2 + 1, this._fields, i2, this._size - i2);
        this._fields[this._size] = null;
    }

    public long getLongField(String name) throws NumberFormatException {
        HttpField field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    public int hashCode() {
        int hash = 0;
        for (HttpField field : this._fields) {
            hash += field.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof HttpFields)) {
            return false;
        }
        HttpFields that = (HttpFields)o2;
        if (this.size() != that.size()) {
            return false;
        }
        block0: for (HttpField fi : this) {
            for (HttpField fa : that) {
                if (!fi.equals(fa)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            for (HttpField field : this) {
                if (field == null) continue;
                String tmp = field.getName();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append(": ");
                tmp = field.getValue();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            return buffer.toString();
        }
        catch (Exception e2) {
            LOG.warn(e2);
            return e2.toString();
        }
    }

    public void add(HttpField field) {
        if (field != null) {
            if (this._size == this._fields.length) {
                this._fields = Arrays.copyOf(this._fields, this._size * 2);
            }
            this._fields[this._size++] = field;
        }
    }

    static /* synthetic */ HttpField[] access$202(HttpFields x0, HttpField[] x1) {
        x0._fields = x1;
        return x1;
    }

    static {
        __qualities.put("*", __one);
        __qualities.put("1.0", __one);
        __qualities.put("1", __one);
        __qualities.put("0.9", new Float("0.9"));
        __qualities.put("0.8", new Float("0.8"));
        __qualities.put("0.7", new Float("0.7"));
        __qualities.put("0.66", new Float("0.66"));
        __qualities.put("0.6", new Float("0.6"));
        __qualities.put("0.5", new Float("0.5"));
        __qualities.put("0.4", new Float("0.4"));
        __qualities.put("0.33", new Float("0.33"));
        __qualities.put("0.3", new Float("0.3"));
        __qualities.put("0.2", new Float("0.2"));
        __qualities.put("0.1", new Float("0.1"));
        __qualities.put("0", __zero);
        __qualities.put("0.0", __zero);
    }

    private class ListItr
    implements ListIterator<HttpField> {
        int _cursor;
        int _current = -1;

        private ListItr() {
        }

        @Override
        public boolean hasNext() {
            return this._cursor != HttpFields.this._size;
        }

        @Override
        public HttpField next() {
            if (this._cursor == HttpFields.this._size) {
                throw new NoSuchElementException();
            }
            this._current = this._cursor++;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public void remove() {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            HttpFields.this.remove(this._current);
            ((HttpFields)HttpFields.this)._fields[((HttpFields)HttpFields.this)._size] = null;
            this._cursor = this._current;
            this._current = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public HttpField previous() {
            if (this._cursor == 0) {
                throw new NoSuchElementException();
            }
            this._current = --this._cursor;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public int nextIndex() {
            return this._cursor;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void set(HttpField field) {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            if (field == null) {
                this.remove();
            } else {
                ((HttpFields)HttpFields.this)._fields[this._current] = field;
            }
        }

        @Override
        public void add(HttpField field) {
            if (field != null) {
                HttpFields.access$202(HttpFields.this, Arrays.copyOf(HttpFields.this._fields, HttpFields.this._fields.length + 1));
                System.arraycopy(HttpFields.this._fields, this._cursor, HttpFields.this._fields, this._cursor + 1, HttpFields.this._size - this._cursor);
                ((HttpFields)HttpFields.this)._fields[this._cursor++] = field;
                HttpFields.this._size++;
                this._current = -1;
            }
        }
    }
}

