/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.v1;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

abstract class ByteArrayWrapper {
    private final byte[] bytes;

    ByteArrayWrapper(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return Objects.requireNonNull(this.bytes);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ByteArrayWrapper fileHash = (ByteArrayWrapper)o2;
        return Arrays.equals(this.bytes, fileHash.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{bytes=" + Arrays.toString(this.bytes) + '}';
    }

    static abstract class Deserializer<T extends ByteArrayWrapper>
    extends StdDeserializer<T> {
        private final Function<byte[], T> creator;

        Deserializer(Class<T> type, Function<byte[], T> creator) {
            super(type);
            this.creator = creator;
        }

        @Override
        public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(16);
            parser.readBinaryValue(stream);
            return (T)((ByteArrayWrapper)this.creator.apply(stream.toByteArray()));
        }
    }

    static abstract class Serializer<T extends ByteArrayWrapper>
    extends StdSerializer<T> {
        Serializer(Class<T> type) {
            super(type);
        }

        @Override
        public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeBinary(((ByteArrayWrapper)value).getBytes());
        }
    }
}

