/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.v1;

import com.gradle.enterprise.testselection.common.model.api.v1.ClassNameHash;
import com.gradle.enterprise.testselection.common.model.api.v1.DebugData;
import com.gradle.enterprise.testselection.common.model.api.v1.InputDebugData;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectionDebugData;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="DebugData", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableDebugData
implements DebugData {
    private final String requestId;
    private final byte[] inferenceDataHash;
    private final Duration selectionDuration;
    private final List<String> modelFeatureNames;
    private final Map<ClassNameHash, SelectionDebugData> selectionDebugData;
    private final InputDebugData inputs;

    private ImmutableDebugData() {
        this.requestId = null;
        this.inferenceDataHash = null;
        this.selectionDuration = null;
        this.modelFeatureNames = null;
        this.selectionDebugData = null;
        this.inputs = null;
    }

    private ImmutableDebugData(String requestId, byte[] inferenceDataHash, Duration selectionDuration, Iterable<String> modelFeatureNames, Map<? extends ClassNameHash, ? extends SelectionDebugData> selectionDebugData, InputDebugData inputs) {
        this.requestId = Objects.requireNonNull(requestId, "requestId");
        this.inferenceDataHash = (byte[])inferenceDataHash.clone();
        this.selectionDuration = Objects.requireNonNull(selectionDuration, "selectionDuration");
        this.modelFeatureNames = ImmutableDebugData.createUnmodifiableList(false, ImmutableDebugData.createSafeList(modelFeatureNames, true, false));
        this.selectionDebugData = ImmutableDebugData.createUnmodifiableMap(true, false, selectionDebugData);
        this.inputs = Objects.requireNonNull(inputs, "inputs");
    }

    private ImmutableDebugData(Builder builder) {
        this.requestId = builder.requestId;
        this.inferenceDataHash = builder.inferenceDataHash;
        this.selectionDuration = builder.selectionDuration;
        this.modelFeatureNames = ImmutableDebugData.createUnmodifiableList(true, builder.modelFeatureNames);
        this.selectionDebugData = ImmutableDebugData.createUnmodifiableMap(false, false, builder.selectionDebugData);
        this.inputs = builder.inputs;
    }

    @Override
    @JsonProperty(value="requestId")
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    @JsonProperty(value="inferenceDataHash")
    public byte[] getInferenceDataHash() {
        return (byte[])this.inferenceDataHash.clone();
    }

    @Override
    @JsonProperty(value="selectionDuration")
    public Duration getSelectionDuration() {
        return this.selectionDuration;
    }

    @Override
    @JsonProperty(value="modelFeatureNames")
    public List<String> getModelFeatureNames() {
        return this.modelFeatureNames;
    }

    @Override
    @JsonProperty(value="selectionDebugData")
    @JsonDeserialize(keyUsing=DebugData.ClassNameHashDeserializer.class)
    public Map<ClassNameHash, SelectionDebugData> getSelectionDebugData() {
        return this.selectionDebugData;
    }

    @Override
    @JsonProperty(value="inputs")
    public InputDebugData getInputs() {
        return this.inputs;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDebugData && this.equalTo(0, (ImmutableDebugData)another);
    }

    private boolean equalTo(int synthetic, ImmutableDebugData another) {
        return this.requestId.equals(another.requestId) && Arrays.equals(this.inferenceDataHash, another.inferenceDataHash) && this.selectionDuration.equals(another.selectionDuration) && this.modelFeatureNames.equals(another.modelFeatureNames) && this.selectionDebugData.equals(another.selectionDebugData) && this.inputs.equals(another.inputs);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.requestId.hashCode();
        h2 += (h2 << 5) + Arrays.hashCode(this.inferenceDataHash);
        h2 += (h2 << 5) + this.selectionDuration.hashCode();
        h2 += (h2 << 5) + this.modelFeatureNames.hashCode();
        h2 += (h2 << 5) + this.selectionDebugData.hashCode();
        h2 += (h2 << 5) + this.inputs.hashCode();
        return h2;
    }

    public String toString() {
        return "DebugData{requestId=" + this.requestId + ", inferenceDataHash=" + Arrays.toString(this.inferenceDataHash) + ", selectionDuration=" + this.selectionDuration + ", modelFeatureNames=" + this.modelFeatureNames + ", selectionDebugData=" + this.selectionDebugData + ", inputs=" + this.inputs + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDebugData fromJson(Json json) {
        Builder builder = ImmutableDebugData.builder();
        if (json.requestId != null) {
            builder.requestId(json.requestId);
        }
        if (json.inferenceDataHash != null) {
            builder.inferenceDataHash(json.inferenceDataHash);
        }
        if (json.selectionDuration != null) {
            builder.selectionDuration(json.selectionDuration);
        }
        if (json.modelFeatureNames != null) {
            builder.addAllModelFeatureNames(json.modelFeatureNames);
        }
        if (json.selectionDebugData != null) {
            builder.putAllSelectionDebugData(json.selectionDebugData);
        }
        if (json.inputs != null) {
            builder.inputs(json.inputs);
        }
        return (ImmutableDebugData)builder.build();
    }

    public static DebugData of(String requestId, byte[] inferenceDataHash, Duration selectionDuration, List<String> modelFeatureNames, Map<ClassNameHash, SelectionDebugData> selectionDebugData, InputDebugData inputs) {
        return ImmutableDebugData.of(requestId, inferenceDataHash, selectionDuration, modelFeatureNames, selectionDebugData, inputs);
    }

    public static DebugData of(String requestId, byte[] inferenceDataHash, Duration selectionDuration, Iterable<String> modelFeatureNames, Map<? extends ClassNameHash, ? extends SelectionDebugData> selectionDebugData, InputDebugData inputs) {
        return new ImmutableDebugData(requestId, inferenceDataHash, selectionDuration, modelFeatureNames, selectionDebugData, inputs);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e2 = map.entrySet().iterator().next();
                K k2 = e2.getKey();
                V v2 = e2.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k2, "key");
                    Objects.requireNonNull(v2, "value");
                }
                if (skipNulls && (k2 == null || v2 == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k2, v2);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e3 : map.entrySet()) {
                K k3 = e3.getKey();
                V v3 = e3.getValue();
                if (skipNulls) {
                    if (k3 == null || v3 == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k3, "key");
                    Objects.requireNonNull(v3, "value");
                }
                linkedMap.put(k3, v3);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DebugData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REQUEST_ID = 1L;
        private static final long INIT_BIT_INFERENCE_DATA_HASH = 2L;
        private static final long INIT_BIT_SELECTION_DURATION = 4L;
        private static final long INIT_BIT_INPUTS = 8L;
        private long initBits = 15L;
        private String requestId;
        private byte[] inferenceDataHash;
        private Duration selectionDuration;
        private List<String> modelFeatureNames = new ArrayList<String>();
        private Map<ClassNameHash, SelectionDebugData> selectionDebugData = new LinkedHashMap<ClassNameHash, SelectionDebugData>();
        private InputDebugData inputs;

        private Builder() {
        }

        public final Builder from(DebugData instance) {
            Objects.requireNonNull(instance, "instance");
            this.requestId(instance.getRequestId());
            this.inferenceDataHash(instance.getInferenceDataHash());
            this.selectionDuration(instance.getSelectionDuration());
            this.addAllModelFeatureNames(instance.getModelFeatureNames());
            this.putAllSelectionDebugData(instance.getSelectionDebugData());
            this.inputs(instance.getInputs());
            return this;
        }

        @JsonProperty(value="requestId")
        public final Builder requestId(String requestId) {
            this.requestId = Objects.requireNonNull(requestId, "requestId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="inferenceDataHash")
        public final Builder inferenceDataHash(byte ... inferenceDataHash) {
            this.inferenceDataHash = (byte[])inferenceDataHash.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="selectionDuration")
        public final Builder selectionDuration(Duration selectionDuration) {
            this.selectionDuration = Objects.requireNonNull(selectionDuration, "selectionDuration");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addModelFeatureNames(String element) {
            this.modelFeatureNames.add(Objects.requireNonNull(element, "modelFeatureNames element"));
            return this;
        }

        public final Builder addModelFeatureNames(String ... elements) {
            for (String element : elements) {
                this.modelFeatureNames.add(Objects.requireNonNull(element, "modelFeatureNames element"));
            }
            return this;
        }

        @JsonProperty(value="modelFeatureNames")
        public final Builder modelFeatureNames(Iterable<String> elements) {
            this.modelFeatureNames.clear();
            return this.addAllModelFeatureNames(elements);
        }

        public final Builder addAllModelFeatureNames(Iterable<String> elements) {
            for (String element : elements) {
                this.modelFeatureNames.add(Objects.requireNonNull(element, "modelFeatureNames element"));
            }
            return this;
        }

        public final Builder putSelectionDebugData(ClassNameHash key, SelectionDebugData value) {
            this.selectionDebugData.put(Objects.requireNonNull(key, "selectionDebugData key"), Objects.requireNonNull(value, "selectionDebugData value"));
            return this;
        }

        public final Builder putSelectionDebugData(Map.Entry<? extends ClassNameHash, ? extends SelectionDebugData> entry) {
            ClassNameHash k2 = entry.getKey();
            SelectionDebugData v2 = entry.getValue();
            this.selectionDebugData.put(Objects.requireNonNull(k2, "selectionDebugData key"), Objects.requireNonNull(v2, "selectionDebugData value"));
            return this;
        }

        @JsonProperty(value="selectionDebugData")
        @JsonDeserialize(keyUsing=DebugData.ClassNameHashDeserializer.class)
        public final Builder selectionDebugData(Map<? extends ClassNameHash, ? extends SelectionDebugData> entries) {
            this.selectionDebugData.clear();
            return this.putAllSelectionDebugData(entries);
        }

        public final Builder putAllSelectionDebugData(Map<? extends ClassNameHash, ? extends SelectionDebugData> entries) {
            for (Map.Entry<? extends ClassNameHash, ? extends SelectionDebugData> e2 : entries.entrySet()) {
                ClassNameHash k2 = e2.getKey();
                SelectionDebugData v2 = e2.getValue();
                this.selectionDebugData.put(Objects.requireNonNull(k2, "selectionDebugData key"), Objects.requireNonNull(v2, "selectionDebugData value"));
            }
            return this;
        }

        @JsonProperty(value="inputs")
        public final Builder inputs(InputDebugData inputs) {
            this.inputs = Objects.requireNonNull(inputs, "inputs");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public DebugData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDebugData(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("requestId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("inferenceDataHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("selectionDuration");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("inputs");
            }
            return "Cannot build DebugData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DebugData", generator="Immutables")
    static final class Json
    implements DebugData {
        String requestId;
        byte[] inferenceDataHash;
        Duration selectionDuration;
        List<String> modelFeatureNames = Collections.emptyList();
        Map<ClassNameHash, SelectionDebugData> selectionDebugData = Collections.emptyMap();
        InputDebugData inputs;

        Json() {
        }

        @JsonProperty(value="requestId")
        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @JsonProperty(value="inferenceDataHash")
        public void setInferenceDataHash(byte[] inferenceDataHash) {
            this.inferenceDataHash = inferenceDataHash;
        }

        @JsonProperty(value="selectionDuration")
        public void setSelectionDuration(Duration selectionDuration) {
            this.selectionDuration = selectionDuration;
        }

        @JsonProperty(value="modelFeatureNames")
        public void setModelFeatureNames(List<String> modelFeatureNames) {
            this.modelFeatureNames = modelFeatureNames;
        }

        @JsonProperty(value="selectionDebugData")
        @JsonDeserialize(keyUsing=DebugData.ClassNameHashDeserializer.class)
        public void setSelectionDebugData(Map<ClassNameHash, SelectionDebugData> selectionDebugData) {
            this.selectionDebugData = selectionDebugData;
        }

        @JsonProperty(value="inputs")
        public void setInputs(InputDebugData inputs) {
            this.inputs = inputs;
        }

        @Override
        public String getRequestId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getInferenceDataHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Duration getSelectionDuration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getModelFeatureNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<ClassNameHash, SelectionDebugData> getSelectionDebugData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputDebugData getInputs() {
            throw new UnsupportedOperationException();
        }
    }
}

