/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.v1;

import com.gradle.enterprise.testselection.common.model.api.v1.SelectionDebugData;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="SelectionDebugData", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableSelectionDebugData
implements SelectionDebugData {
    private final float relevanceScore;
    private final float[] modelFeatures;

    private ImmutableSelectionDebugData() {
        this.relevanceScore = 0.0f;
        this.modelFeatures = null;
    }

    private ImmutableSelectionDebugData(float relevanceScore, float[] modelFeatures) {
        this.relevanceScore = relevanceScore;
        this.modelFeatures = (float[])modelFeatures.clone();
    }

    private ImmutableSelectionDebugData(Builder builder) {
        this.relevanceScore = builder.relevanceScore;
        this.modelFeatures = builder.modelFeatures != null ? builder.modelFeatures : (float[])SelectionDebugData.super.getModelFeatures().clone();
    }

    @Override
    @JsonProperty(value="relevanceScore")
    public float getRelevanceScore() {
        return this.relevanceScore;
    }

    @Override
    @JsonProperty(value="modelFeatures")
    public float[] getModelFeatures() {
        return (float[])this.modelFeatures.clone();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSelectionDebugData && this.equalTo(0, (ImmutableSelectionDebugData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSelectionDebugData another) {
        return Float.floatToIntBits(this.relevanceScore) == Float.floatToIntBits(another.relevanceScore) && Arrays.equals(this.modelFeatures, another.modelFeatures);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Float.hashCode(this.relevanceScore);
        h2 += (h2 << 5) + Arrays.hashCode(this.modelFeatures);
        return h2;
    }

    public String toString() {
        return "SelectionDebugData{relevanceScore=" + this.relevanceScore + ", modelFeatures=" + Arrays.toString(this.modelFeatures) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSelectionDebugData fromJson(Json json) {
        Builder builder = ImmutableSelectionDebugData.builder();
        if (json.relevanceScoreIsSet) {
            builder.relevanceScore(json.relevanceScore);
        }
        if (json.modelFeatures != null) {
            builder.modelFeatures(json.modelFeatures);
        }
        return (ImmutableSelectionDebugData)builder.build();
    }

    public static SelectionDebugData of(float relevanceScore, float[] modelFeatures) {
        return new ImmutableSelectionDebugData(relevanceScore, modelFeatures);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SelectionDebugData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RELEVANCE_SCORE = 1L;
        private long initBits = 1L;
        private float relevanceScore;
        private float[] modelFeatures;

        private Builder() {
        }

        public final Builder from(SelectionDebugData instance) {
            Objects.requireNonNull(instance, "instance");
            this.relevanceScore(instance.getRelevanceScore());
            this.modelFeatures(instance.getModelFeatures());
            return this;
        }

        @JsonProperty(value="relevanceScore")
        public final Builder relevanceScore(float relevanceScore) {
            this.relevanceScore = relevanceScore;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="modelFeatures")
        public final Builder modelFeatures(float ... modelFeatures) {
            this.modelFeatures = (float[])modelFeatures.clone();
            return this;
        }

        public SelectionDebugData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSelectionDebugData(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relevanceScore");
            }
            return "Cannot build SelectionDebugData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SelectionDebugData", generator="Immutables")
    static final class Json
    implements SelectionDebugData {
        float relevanceScore;
        boolean relevanceScoreIsSet;
        float[] modelFeatures;

        Json() {
        }

        @JsonProperty(value="relevanceScore")
        public void setRelevanceScore(float relevanceScore) {
            this.relevanceScore = relevanceScore;
            this.relevanceScoreIsSet = true;
        }

        @JsonProperty(value="modelFeatures")
        public void setModelFeatures(float[] modelFeatures) {
            this.modelFeatures = modelFeatures;
        }

        @Override
        public float getRelevanceScore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] getModelFeatures() {
            throw new UnsupportedOperationException();
        }
    }
}

