/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParserBootstrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class SmileFactory
extends JsonFactory {
    static final int DEFAULT_SMILE_PARSER_FEATURE_FLAGS = SmileParser.Feature.collectDefaults();
    static final int DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS = SmileGenerator.Feature.collectDefaults();
    protected boolean _cfgDelegateToTextual;
    protected int _smileParserFeatures = DEFAULT_SMILE_PARSER_FEATURE_FLAGS;
    protected int _smileGeneratorFeatures = DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS;

    public SmileFactory() {
        this(null);
    }

    public SmileFactory(ObjectCodec oc) {
        super(oc);
    }

    @Override
    public String getFormatName() {
        return "Smile";
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    @Override
    public SmileParser createParser(InputStream in) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(in), false);
        return this._createParser(this._decorate(in, ctxt), ctxt);
    }

    @Override
    public SmileParser createParser(byte[] data) throws IOException {
        return this.createParser(data, 0, data.length);
    }

    public SmileParser createParser(byte[] data, int offset, int len) throws IOException {
        InputStream in;
        IOContext ctxt = this._createContext(this._createContentReference(data, offset, len), true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, 0, data.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, offset, len, ctxt);
    }

    @Override
    public SmileGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(out), false);
        return this._createGenerator(this._decorate(out, ctxt), ctxt);
    }

    @Override
    public SmileGenerator createGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(this._createContentReference(out), false);
        return this._createGenerator(this._decorate(out, ctxt), ctxt);
    }

    @Override
    protected SmileParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        SmileParserBootstrapper bs2 = new SmileParserBootstrapper(ctxt, in);
        return bs2.constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected JsonParser _createParser(Reader r2, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(r2, ctxt);
        }
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(data, offset, len, ctxt, recyclable);
        }
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected SmileParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return new SmileParserBootstrapper(ctxt, data, offset, len).constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createGenerator(out, ctxt);
        }
        return (JsonGenerator)this._nonByteTarget();
    }

    @Override
    protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createGenerator(out, ctxt);
    }

    @Override
    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createWriter(out, enc, ctxt);
        }
        return (Writer)this._nonByteTarget();
    }

    protected <T> T _nonByteSource() throws IOException {
        throw new UnsupportedOperationException("Can not create parser for character-based (not byte-based) source");
    }

    protected <T> T _nonByteTarget() throws IOException {
        throw new UnsupportedOperationException("Can not create generator for character-based (not byte-based) target");
    }

    protected SmileGenerator _createGenerator(OutputStream out, IOContext ctxt) throws IOException {
        int feats = this._smileGeneratorFeatures;
        SmileGenerator gen = new SmileGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out);
        if ((feats & SmileGenerator.Feature.WRITE_HEADER.getMask()) != 0) {
            gen.writeHeader();
        } else {
            if ((feats & SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but CHECK_SHARED_STRING_VALUES enabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or disable CHECK_SHARED_STRING_VALUES to resolve)", gen);
            }
            if ((feats & SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but ENCODE_BINARY_AS_7BIT disabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or ENCODE_BINARY_AS_7BIT to resolve)", gen);
            }
        }
        return gen;
    }
}

