/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jdk8;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalLong;

public class OptionalLongDeserializer
extends BaseScalarOptionalDeserializer<OptionalLong> {
    static final OptionalLongDeserializer INSTANCE = new OptionalLongDeserializer();

    public OptionalLongDeserializer() {
        super(OptionalLong.class, OptionalLong.empty());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public OptionalLong deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return OptionalLong.of(p2.getLongValue());
        }
        switch (p2.currentTokenId()) {
            case 6: {
                String text = p2.getText();
                CoercionAction act = this._checkFromStringCoercion(ctxt, text);
                if (act == CoercionAction.AsNull || act == CoercionAction.AsEmpty) {
                    return (OptionalLong)this._empty;
                }
                text = text.trim();
                return OptionalLong.of(this._parseLongPrimitive(ctxt, text));
            }
            case 8: {
                CoercionAction act = this._checkFloatToIntCoercion(p2, ctxt, this._valueClass);
                if (act == CoercionAction.AsNull || act == CoercionAction.AsEmpty) {
                    return (OptionalLong)this._empty;
                }
                return OptionalLong.of(p2.getValueAsLong());
            }
            case 11: {
                return (OptionalLong)this._empty;
            }
            case 3: {
                return (OptionalLong)this._deserializeFromArray(p2, ctxt);
            }
        }
        return (OptionalLong)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2);
    }
}

