/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe;

import com.gradle.maven.extension.internal.dep.dev.failsafe.Policy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.util.Assert;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionInternal;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.PolicyExecutor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;

class ExecutionImpl<R>
implements ExecutionInternal<R> {
    final List<PolicyExecutor<R>> policyExecutors;
    private volatile Duration startTime;
    private AtomicInteger attempts;
    private AtomicInteger executions;
    private final ExecutionResult<R> previousResult;
    volatile ExecutionResult<R> result;
    volatile Duration attemptStartTime;
    volatile int cancelledIndex = Integer.MIN_VALUE;
    private volatile boolean preExecuted;
    volatile boolean attemptRecorded;
    volatile boolean completed;

    ExecutionImpl(List<? extends Policy<R>> policies) {
        this.policyExecutors = new ArrayList<PolicyExecutor<R>>(policies.size());
        this.startTime = Duration.ZERO;
        this.attemptStartTime = Duration.ZERO;
        this.attempts = new AtomicInteger();
        this.executions = new AtomicInteger();
        this.previousResult = null;
        ListIterator<Policy<R>> policyIterator = policies.listIterator(policies.size());
        int i2 = 0;
        while (policyIterator.hasPrevious()) {
            Policy<R> policy = Assert.notNull(policyIterator.previous(), "policies");
            PolicyExecutor<R> policyExecutor = policy.toExecutor(i2);
            this.policyExecutors.add(policyExecutor);
            ++i2;
        }
    }

    ExecutionImpl(ExecutionImpl<R> execution) {
        this.policyExecutors = execution.policyExecutors;
        this.startTime = execution.startTime;
        this.attempts = execution.attempts;
        this.executions = execution.executions;
        this.previousResult = execution.result;
    }

    @Override
    public ExecutionResult<R> getResult() {
        return this.result;
    }

    @Override
    public synchronized void preExecute() {
        if (!this.preExecuted) {
            this.attemptStartTime = Duration.ofNanos(System.nanoTime());
            if (this.startTime == Duration.ZERO) {
                this.startTime = this.attemptStartTime;
            }
            this.preExecuted = true;
        }
    }

    @Override
    public boolean isPreExecuted() {
        return this.preExecuted;
    }

    @Override
    public synchronized void recordAttempt() {
        if (!this.attemptRecorded) {
            this.attempts.incrementAndGet();
            this.attemptRecorded = true;
        }
    }

    @Override
    public synchronized void record(ExecutionResult<R> result) {
        if (this.preExecuted && !this.attemptRecorded) {
            this.recordAttempt();
            this.executions.incrementAndGet();
            this.result = result;
        }
    }

    @Override
    public void cancel() {
        this.cancelledIndex = Integer.MAX_VALUE;
    }

    @Override
    public boolean isCancelled(PolicyExecutor<R> policyExecutor) {
        return this.cancelledIndex > policyExecutor.getPolicyIndex();
    }

    @Override
    public Duration getElapsedTime() {
        return Duration.ofNanos(System.nanoTime() - this.startTime.toNanos());
    }

    @Override
    public int getAttemptCount() {
        return this.attempts.get();
    }

    @Override
    public <T extends Throwable> T getLastFailure() {
        ExecutionResult<R> r2 = this.result != null ? this.result : this.previousResult;
        return (T)(r2 == null ? null : r2.getFailure());
    }

    @Override
    public R getLastResult() {
        ExecutionResult<R> r2 = this.result != null ? this.result : this.previousResult;
        return r2 == null ? null : (R)r2.getResult();
    }

    public String toString() {
        return "[attempts=" + this.attempts + ", executions=" + this.executions + ", lastResult=" + this.getLastResult() + ", lastFailure=" + this.getLastFailure() + ']';
    }
}

