/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe;

import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.dev.failsafe.FailsafeException;
import com.gradle.maven.extension.internal.dep.dev.failsafe.function.CheckedSupplier;
import com.gradle.maven.extension.internal.dep.dev.failsafe.function.ContextualSupplier;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.util.Assert;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.AsyncExecutionInternal;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.FailsafeFuture;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.Scheduler;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

final class Functions {
    static <R> Function<SyncExecutionInternal<R>, ExecutionResult<R>> get(ContextualSupplier<R, R> supplier, Executor executor) {
        return execution -> {
            ExecutionResult<Object> result;
            Throwable throwable = null;
            try {
                execution.preExecute();
                result = ExecutionResult.success(Functions.withExecutor(supplier, executor).get((ExecutionContext)execution));
            }
            catch (Throwable t2) {
                throwable = t2;
                result = ExecutionResult.failure(t2);
            }
            execution.record(result);
            SyncExecutionInternal syncExecutionInternal = execution.getInitial();
            synchronized (syncExecutionInternal) {
                execution.setInterruptable(false);
                if (execution.isInterrupted()) {
                    Thread.interrupted();
                    return execution.getResult();
                }
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return result;
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> getPromiseOfStage(ContextualSupplier<R, ? extends CompletionStage<? extends R>> supplier, FailsafeFuture<R> future) {
        Assert.notNull(supplier, "supplier");
        return execution -> {
            CompletableFuture promise = new CompletableFuture();
            try {
                execution.preExecute();
                CompletionStage stage = (CompletionStage)supplier.get((ExecutionContext)execution);
                if (stage instanceof Future) {
                    future.propagateCancellation((Future)((Object)stage));
                }
                stage.whenComplete((result, failure) -> {
                    if (failure instanceof CompletionException) {
                        failure = failure.getCause();
                    }
                    ExecutionResult<Object> r2 = failure == null ? ExecutionResult.success(result) : ExecutionResult.failure(failure);
                    execution.record(r2);
                    promise.complete(r2);
                });
            }
            catch (Throwable t2) {
                ExecutionResult result2 = ExecutionResult.failure(t2);
                execution.record(result2);
                promise.complete(result2);
            }
            return promise;
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> toExecutionAware(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn) {
        return execution -> {
            ExecutionResult result = execution.getResult();
            if (result == null) {
                return (CompletableFuture)innerFn.apply((AsyncExecutionInternal)execution);
            }
            return CompletableFuture.completedFuture(result);
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> toAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        AtomicBoolean scheduled = new AtomicBoolean();
        return execution -> {
            if (scheduled.get()) {
                return (CompletableFuture)innerFn.apply((AsyncExecutionInternal)execution);
            }
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> ((CompletableFuture)innerFn.apply((AsyncExecutionInternal)execution)).whenComplete((result, error) -> {
                if (error != null) {
                    promise.completeExceptionally((Throwable)error);
                } else {
                    promise.complete(result);
                }
            });
            try {
                scheduled.set(true);
                ScheduledFuture<?> scheduledFuture = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                future.setCancelFn(-1, (mayInterrupt, cancelResult) -> {
                    scheduledFuture.cancel((boolean)mayInterrupt);
                    if (!execution.isPreExecuted()) {
                        promise.complete(cancelResult);
                    }
                });
            }
            catch (Throwable t2) {
                promise.completeExceptionally(t2);
            }
            return promise;
        };
    }

    static <R, T> ContextualSupplier<R, T> toCtxSupplier(CheckedSupplier<T> supplier) {
        Assert.notNull(supplier, "supplier");
        return ctx -> supplier.get();
    }

    static <R, T> ContextualSupplier<R, T> withExecutor(ContextualSupplier<R, T> supplier, Executor executor) {
        return executor == null ? supplier : ctx -> {
            executor.execute(() -> {
                try {
                    supplier.get(ctx);
                }
                catch (Throwable e2) {
                    Functions.handleExecutorThrowable(e2);
                }
            });
            return null;
        };
    }

    private static void handleExecutorThrowable(Throwable e2) {
        if (e2 instanceof RuntimeException) {
            throw (RuntimeException)e2;
        }
        if (e2 instanceof Error) {
            throw (Error)e2;
        }
        throw new FailsafeException(e2);
    }
}

