/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.io.IoFunction;
import org.gradle.internal.normalization.java.ApiClassExtractor;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbiExtractingClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbiExtractingClasspathResourceHasher.class);
    public static final AbiExtractingClasspathResourceHasher DEFAULT = AbiExtractingClasspathResourceHasher.withFallback(new ApiClassExtractor(Collections.emptySet()));
    private final ApiClassExtractor extractor;
    private final FallbackStrategy fallbackStrategy;

    private AbiExtractingClasspathResourceHasher(ApiClassExtractor extractor, FallbackStrategy fallbackStrategy) {
        this.extractor = extractor;
        this.fallbackStrategy = fallbackStrategy;
    }

    public static AbiExtractingClasspathResourceHasher withFallback(ApiClassExtractor extractor) {
        return new AbiExtractingClasspathResourceHasher(extractor, FallbackStrategy.FULL_HASH);
    }

    private HashCode hashClassBytes(byte[] classBytes) {
        ClassReader reader = new ClassReader(classBytes);
        return this.extractor.extractApiClassFrom(reader).map(Hashing::hashBytes).orElse(null);
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext fileSnapshotContext) throws IOException {
        RegularFileSnapshot fileSnapshot = fileSnapshotContext.getSnapshot();
        if (this.isNotClassFile(fileSnapshot.getName())) {
            return null;
        }
        return this.fallbackStrategy.handle(fileSnapshot, snapshot -> {
            Path path = Paths.get(snapshot.getAbsolutePath(), new String[0]);
            byte[] classBytes = Files.readAllBytes(path);
            return this.hashClassBytes(classBytes);
        });
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        ZipEntry zipEntry = zipEntryContext.getEntry();
        if (this.isNotClassFile(zipEntry.getName())) {
            return null;
        }
        byte[] content = zipEntry.getContent();
        return this.fallbackStrategy.handle(new ZipEntryContent(zipEntry.getName(), content), entry -> this.hashClassBytes(content));
    }

    private boolean isNotClassFile(String name) {
        return !name.endsWith(".class");
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        this.extractor.appendConfigurationToHasher(hasher);
    }

    static enum FallbackStrategy {
        FULL_HASH{

            @Override
            HashCode handle(RegularFileSnapshot fileSnapshot, IoFunction<RegularFileSnapshot, HashCode> function) {
                try {
                    return function.apply(fileSnapshot);
                }
                catch (Exception e2) {
                    LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)fileSnapshot.getName(), (Object)e2);
                    return fileSnapshot.getHash();
                }
            }

            @Override
            HashCode handle(ZipEntryContent zipEntry, IoFunction<ZipEntryContent, HashCode> function) {
                try {
                    return function.apply(zipEntry);
                }
                catch (Exception e2) {
                    LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)zipEntry.name, (Object)e2);
                    return Hashing.hashBytes(zipEntry.content);
                }
            }
        }
        ,
        NONE{

            @Override
            HashCode handle(RegularFileSnapshot fileSnapshot, IoFunction<RegularFileSnapshot, HashCode> function) throws IOException {
                return function.apply(fileSnapshot);
            }

            @Override
            HashCode handle(ZipEntryContent zipEntry, IoFunction<ZipEntryContent, HashCode> function) throws IOException {
                return function.apply(zipEntry);
            }
        };


        abstract HashCode handle(RegularFileSnapshot var1, IoFunction<RegularFileSnapshot, HashCode> var2) throws IOException;

        abstract HashCode handle(ZipEntryContent var1, IoFunction<ZipEntryContent, HashCode> var2) throws IOException;
    }

    private static class ZipEntryContent {
        final String name;
        final byte[] content;

        ZipEntryContent(String name, byte[] content) {
            this.name = name;
            this.content = content;
        }
    }
}

