/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gradle.api.internal.changedetection.state.DefaultZipEntryContext;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.api.internal.file.archive.impl.StreamZipInput;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.ConfigurableNormalizer;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContextHasher;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHasher
implements ConfigurableNormalizer,
RegularFileSnapshotContextHasher {
    private static final Set<String> KNOWN_ZIP_EXTENSIONS = ImmutableSet.of("zip", "jar", "war", "rar", "ear", "apk", new String[]{"aar"});
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipHasher.class);
    private static final HashCode EMPTY_HASH_MARKER = Hashing.signature(ZipHasher.class);
    private final ResourceHasher resourceHasher;
    private final HashingExceptionReporter hashingExceptionReporter;

    public static boolean isZipFile(String name) {
        return KNOWN_ZIP_EXTENSIONS.contains(FilenameUtils.getExtension(name).toLowerCase(Locale.ROOT));
    }

    public ZipHasher(ResourceHasher resourceHasher) {
        this(resourceHasher, (s2, e2) -> LOGGER.debug("Malformed archive '{}'. Falling back to full content hash instead of entry hashing.", (Object)s2.getName(), (Object)e2));
    }

    public ZipHasher(ResourceHasher resourceHasher, HashingExceptionReporter hashingExceptionReporter) {
        this.resourceHasher = resourceHasher;
        this.hashingExceptionReporter = hashingExceptionReporter;
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext fileSnapshotContext) {
        return this.hashZipContents(fileSnapshotContext.getSnapshot());
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        this.resourceHasher.appendConfigurationToHasher(hasher);
    }

    private HashCode hashZipContents(RegularFileSnapshot zipFileSnapshot) {
        try {
            List<FileSystemLocationFingerprint> fingerprints = this.fingerprintZipEntries(zipFileSnapshot.getAbsolutePath());
            if (fingerprints.isEmpty()) {
                return null;
            }
            Hasher hasher = Hashing.newHasher();
            FingerprintHashingStrategy.SORT.appendToHasher(hasher, fingerprints);
            return hasher.hash();
        }
        catch (Exception e2) {
            this.hashingExceptionReporter.report(zipFileSnapshot, e2);
            return zipFileSnapshot.getHash();
        }
    }

    private List<FileSystemLocationFingerprint> fingerprintZipEntries(String zipFile) throws IOException {
        try (ZipInput input = FileZipInput.create(new File(zipFile));){
            ArrayList<FileSystemLocationFingerprint> fingerprints = Lists.newArrayList();
            this.fingerprintZipEntries("", zipFile, fingerprints, input);
            ArrayList<FileSystemLocationFingerprint> arrayList = fingerprints;
            return arrayList;
        }
    }

    private void fingerprintZipEntries(String parentName, String rootParentName, List<FileSystemLocationFingerprint> fingerprints, ZipInput input) throws IOException {
        fingerprints.add(this.newZipMarker(parentName));
        for (ZipEntry zipEntry : input) {
            if (zipEntry.isDirectory()) continue;
            String fullName = parentName.isEmpty() ? zipEntry.getName() : parentName + "/" + zipEntry.getName();
            DefaultZipEntryContext zipEntryContext = new DefaultZipEntryContext(zipEntry, fullName, rootParentName);
            if (ZipHasher.isZipFile(zipEntry.getName())) {
                zipEntryContext.getEntry().withInputStream(inputStream -> {
                    this.fingerprintZipEntries(fullName, rootParentName, fingerprints, new StreamZipInput(inputStream));
                    return null;
                });
                continue;
            }
            this.fingerprintZipEntry(zipEntryContext, fingerprints);
        }
    }

    private void fingerprintZipEntry(ZipEntryContext zipEntryContext, List<FileSystemLocationFingerprint> fingerprints) throws IOException {
        HashCode hash = this.resourceHasher.hash(zipEntryContext);
        if (hash != null) {
            fingerprints.add(new DefaultFileSystemLocationFingerprint(zipEntryContext.getFullName(), FileType.RegularFile, hash));
        }
    }

    private DefaultFileSystemLocationFingerprint newZipMarker(String relativePath) {
        return new DefaultFileSystemLocationFingerprint(relativePath, FileType.RegularFile, EMPTY_HASH_MARKER);
    }

    public static interface HashingExceptionReporter {
        public void report(RegularFileSnapshot var1, Exception var2);
    }
}

