/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipInputStream;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.JdkZipEntry;
import org.gradle.internal.file.FileException;

public class StreamZipInput
implements ZipInput {
    private final ZipInputStream in;

    public StreamZipInput(InputStream in) {
        this.in = new ZipInputStream(in);
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            @Override
            protected ZipEntry computeNext() {
                java.util.zip.ZipEntry nextEntry;
                try {
                    nextEntry = StreamZipInput.this.in.getNextEntry();
                }
                catch (IOException e2) {
                    throw new FileException(e2);
                }
                return nextEntry == null ? (ZipEntry)this.endOfData() : new JdkZipEntry(nextEntry, new Supplier<InputStream>(){

                    @Override
                    public InputStream get() {
                        return StreamZipInput.this.in;
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StreamZipInput.this.in.closeEntry();
                        }
                        catch (IOException e2) {
                            throw new FileException(e2);
                        }
                    }
                });
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

