/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Suppliers;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;

public class DefaultBuildCacheTempFileStore
implements BuildCacheTempFileStore {
    private final Supplier<File> dir = Suppliers.memoize(() -> {
        try {
            return Files.createDirectories((Path)dir.get(), new FileAttribute[0]).toFile();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    });

    public DefaultBuildCacheTempFileStore(Supplier<Path> dir) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The location of the storage dir is controlled by us, not the user")
    public void withTempFile(BuildCacheKey key, Consumer<? super File> action) {
        String hashCode = key.getHashCode();
        File tempFile = null;
        try {
            try {
                tempFile = File.createTempFile(hashCode + "-", ".part", this.dir.get());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            action.accept(tempFile);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(tempFile);
            throw throwable;
        }
        FileUtils.deleteQuietly(tempFile);
    }
}

