/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.Serializable;
import org.gradle.internal.hash.PrimitiveHasher;

public abstract class HashCode
implements Serializable,
Comparable<HashCode> {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private HashCode() {
    }

    static HashCode fromBytes(byte[] bytes, Usage usage) {
        switch (bytes.length) {
            case 16: {
                return new HashCode128(HashCode.bytesToLong(bytes, 0), HashCode.bytesToLong(bytes, 8));
            }
        }
        return new ByteArrayBackedHashCode(usage == Usage.CLONE_BYTES_IF_NECESSARY ? (byte[])bytes.clone() : bytes);
    }

    public static HashCode fromBytes(byte[] bytes) {
        if (bytes.length < 4 || bytes.length > 255) {
            throw new IllegalArgumentException(String.format("Invalid hash code length: %d bytes", bytes.length));
        }
        return HashCode.fromBytes(bytes, Usage.CLONE_BYTES_IF_NECESSARY);
    }

    public abstract int length();

    public abstract byte[] toByteArray();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        StringBuilder sb = HashCode.toStringBuilder(2 * this.length(), this.bytes());
        return sb.toString();
    }

    private static StringBuilder toStringBuilder(int capacity, byte[] bytes) {
        StringBuilder sb = new StringBuilder(capacity);
        for (byte b2 : bytes) {
            sb.append(HEX_DIGITS[b2 >> 4 & 0xF]).append(HEX_DIGITS[b2 & 0xF]);
        }
        return sb;
    }

    abstract void appendToHasher(PrimitiveHasher var1);

    abstract byte[] bytes();

    private static int compareLong(long a2, long b2) {
        return a2 < b2 ? -1 : (a2 == b2 ? 0 : 1);
    }

    private static int compareBytes(byte[] a2, byte[] b2) {
        int len1 = a2.length;
        int len2 = b2.length;
        int length = Math.min(len1, len2);
        for (int idx = 0; idx < length; ++idx) {
            int result = a2[idx] - b2[idx];
            if (result == 0) continue;
            return result;
        }
        return len1 - len2;
    }

    private static long bytesToLong(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 7] & 0xFFL) << 56;
    }

    private static void longToBytes(long value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value & 0xFFL);
        bytes[offset + 1] = (byte)(value >>> 8 & 0xFFL);
        bytes[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        bytes[offset + 3] = (byte)(value >>> 24 & 0xFFL);
        bytes[offset + 4] = (byte)(value >>> 32 & 0xFFL);
        bytes[offset + 5] = (byte)(value >>> 40 & 0xFFL);
        bytes[offset + 6] = (byte)(value >>> 48 & 0xFFL);
        bytes[offset + 7] = (byte)(value >>> 56 & 0xFFL);
    }

    private static class ByteArrayBackedHashCode
    extends HashCode {
        private final byte[] bytes;

        public ByteArrayBackedHashCode(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int length() {
            return this.bytes.length;
        }

        @Override
        byte[] bytes() {
            return this.bytes;
        }

        @Override
        public byte[] toByteArray() {
            return (byte[])this.bytes.clone();
        }

        @Override
        void appendToHasher(PrimitiveHasher hasher) {
            hasher.putBytes(this.bytes);
        }

        @Override
        public int hashCode() {
            return this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ByteArrayBackedHashCode.class) {
                return false;
            }
            byte[] b2 = ((ByteArrayBackedHashCode)obj).bytes;
            byte[] a2 = this.bytes;
            int length = a2.length;
            if (b2.length != length) {
                return false;
            }
            for (int i2 = 0; i2 < length; ++i2) {
                if (a2[i2] == b2[i2]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(HashCode o2) {
            return HashCode.compareBytes(this.bytes, o2.bytes());
        }
    }

    static class HashCode128
    extends HashCode {
        private final long bits1;
        private final long bits2;

        public HashCode128(long bits1, long bits2) {
            this.bits1 = bits1;
            this.bits2 = bits2;
        }

        @Override
        public int length() {
            return 16;
        }

        @Override
        byte[] bytes() {
            return this.toByteArray();
        }

        @Override
        public byte[] toByteArray() {
            byte[] bytes = new byte[16];
            HashCode.longToBytes(this.bits1, bytes, 0);
            HashCode.longToBytes(this.bits2, bytes, 8);
            return bytes;
        }

        @Override
        void appendToHasher(PrimitiveHasher hasher) {
            hasher.putLong(this.bits1);
            hasher.putLong(this.bits2);
        }

        @Override
        public int hashCode() {
            return (int)this.bits1;
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || o2.getClass() != HashCode128.class) {
                return false;
            }
            HashCode128 other = (HashCode128)o2;
            return this.bits1 == other.bits1 && this.bits2 == other.bits2;
        }

        @Override
        public int compareTo(HashCode o2) {
            if (o2.getClass() != HashCode128.class) {
                return HashCode.compareBytes(this.bytes(), o2.bytes());
            }
            HashCode128 other = (HashCode128)o2;
            int result = HashCode.compareLong(this.bits1, other.bits1);
            if (result == 0) {
                result = HashCode.compareLong(this.bits2, other.bits2);
            }
            return result;
        }
    }

    static enum Usage {
        CLONE_BYTES_IF_NECESSARY,
        SAFE_TO_REUSE_BYTES;

    }
}

