/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.AbstractFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class RegularFileSnapshot
extends AbstractFileSystemLocationSnapshot
implements FileSystemLeafSnapshot {
    private final HashCode contentHash;
    private final FileMetadata metadata;

    public RegularFileSnapshot(String absolutePath, String name, HashCode contentHash, FileMetadata metadata) {
        super(absolutePath, name, metadata.getAccessType());
        this.contentHash = contentHash;
        this.metadata = metadata;
    }

    @Override
    public FileType getType() {
        return FileType.RegularFile;
    }

    @Override
    public HashCode getHash() {
        return this.contentHash;
    }

    public FileMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor visitor) {
        visitor.visitRegularFile(this);
    }

    @Override
    public <T> T accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<T> transformer) {
        return transformer.visitRegularFile(this);
    }

    @Override
    public String toString() {
        return String.format("%s@%s/%s", super.toString(), this.getHash(), this.getName());
    }
}

