/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe;

import com.gradle.maven.extension.internal.dep.dev.failsafe.AsyncExecutionImpl;
import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.dev.failsafe.FailsafeException;
import com.gradle.maven.extension.internal.dep.dev.failsafe.Functions;
import com.gradle.maven.extension.internal.dep.dev.failsafe.Policy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.SyncExecutionImpl;
import com.gradle.maven.extension.internal.dep.dev.failsafe.function.CheckedSupplier;
import com.gradle.maven.extension.internal.dep.dev.failsafe.function.ContextualSupplier;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.EventHandler;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.AsyncExecutionInternal;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.FailsafeFuture;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.Scheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FailsafeExecutor<R> {
    private Scheduler scheduler = Scheduler.DEFAULT;
    private Executor executor;
    final List<? extends Policy<R>> policies;
    private EventHandler<R> completeHandler;
    private volatile EventHandler<R> failureHandler;
    private volatile EventHandler<R> successHandler;
    final BiConsumer<ExecutionResult<R>, ExecutionContext<R>> completionHandler = (result, context) -> {
        if (this.successHandler != null && result.getSuccessAll()) {
            this.successHandler.handle((ExecutionResult<R>)result, (ExecutionContext<R>)context);
        } else if (this.failureHandler != null && !result.getSuccessAll()) {
            this.failureHandler.handle((ExecutionResult<R>)result, (ExecutionContext<R>)context);
        }
        if (this.completeHandler != null) {
            this.completeHandler.handle((ExecutionResult<R>)result, (ExecutionContext<R>)context);
        }
    };

    FailsafeExecutor(List<? extends Policy<R>> policies) {
        this.policies = policies;
    }

    public <T extends R> T get(CheckedSupplier<T> supplier) {
        return (T)this.call(Functions.toCtxSupplier(supplier));
    }

    public <T extends R> CompletableFuture<T> getStageAsync(CheckedSupplier<? extends CompletionStage<T>> supplier) {
        return this.callAsync(future -> Functions.getPromiseOfStage(Functions.toCtxSupplier(supplier), future), false);
    }

    private <T> T call(ContextualSupplier<T, T> innerSupplier) {
        SyncExecutionImpl execution = new SyncExecutionImpl(this, this.scheduler, Functions.get(innerSupplier, this.executor));
        ExecutionResult result = execution.executeSync();
        Throwable failure = result.getFailure();
        if (failure != null) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new FailsafeException(failure);
        }
        return (T)result.getResult();
    }

    private <T> CompletableFuture<T> callAsync(Function<FailsafeFuture<T>, Function<AsyncExecutionInternal<T>, CompletableFuture<ExecutionResult<T>>>> innerFn, boolean asyncExecution) {
        FailsafeFuture future = new FailsafeFuture(this.completionHandler);
        AsyncExecutionImpl execution = new AsyncExecutionImpl(this.policies, this.scheduler, future, asyncExecution, innerFn.apply(future));
        future.setExecution(execution);
        execution.executeAsync();
        return future;
    }
}

