/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe;

import com.gradle.maven.extension.internal.dep.dev.failsafe.FailurePolicyConfig;
import com.gradle.maven.extension.internal.dep.dev.failsafe.PolicyBuilder;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.util.Assert;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public abstract class FailurePolicyBuilder<S, C extends FailurePolicyConfig<R>, R>
extends PolicyBuilder<S, C, R> {
    protected FailurePolicyBuilder(C config) {
        super(config);
    }

    public S handle(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.handle(Arrays.asList(failure));
    }

    @SafeVarargs
    public final S handle(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.handle(Arrays.asList(failures));
    }

    public S handle(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        ((FailurePolicyConfig)this.config).failuresChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(failures));
        return (S)this;
    }

    public S handleIf(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        ((FailurePolicyConfig)this.config).failuresChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(failurePredicate));
        return (S)this;
    }

    public S handleResultIf(Predicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.resultPredicateFor(resultPredicate));
        return (S)this;
    }

    static <R> BiPredicate<R, Throwable> failurePredicateFor(Predicate<? extends Throwable> failurePredicate) {
        return (t2, u2) -> u2 != null && failurePredicate.test((Throwable)u2);
    }

    static <R> BiPredicate<R, Throwable> resultPredicateFor(Predicate<R> resultPredicate) {
        return (t2, u2) -> {
            if (u2 == null) {
                return resultPredicate.test(t2);
            }
            return false;
        };
    }

    static <R> BiPredicate<R, Throwable> failurePredicateFor(List<Class<? extends Throwable>> failures) {
        return (t2, u2) -> {
            if (u2 == null) {
                return false;
            }
            for (Class failureType : failures) {
                if (!failureType.isAssignableFrom(u2.getClass())) continue;
                return true;
            }
            return false;
        };
    }
}

