/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import org.gradle.caching.BuildCacheEntryWriter;

public class StoreTarget
implements BuildCacheEntryWriter {
    private final File file;
    private boolean stored;

    public StoreTarget(File file) {
        this.file = file;
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        try (OutputStream closingOutput = output;){
            Files.copy(this.file.toPath(), closingOutput);
            this.stored = true;
        }
    }

    public boolean isStored() {
        return this.stored;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }
}

