/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableListMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMultimap;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class SnapshotUtil {
    public static Map<String, FileSystemLocationSnapshot> index(FileSystemSnapshot snapshot) {
        HashMap<String, FileSystemLocationSnapshot> index = new HashMap<String, FileSystemLocationSnapshot>();
        snapshot.accept(entrySnapshot -> {
            index.put(entrySnapshot.getAbsolutePath(), entrySnapshot);
            return SnapshotVisitResult.CONTINUE;
        });
        return index;
    }

    public static ImmutableMultimap<String, HashCode> getRootHashes(FileSystemSnapshot roots) {
        if (roots == FileSystemSnapshot.EMPTY) {
            return ImmutableMultimap.of();
        }
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        roots.accept(snapshot -> {
            builder.put(snapshot.getAbsolutePath(), snapshot.getHash());
            return SnapshotVisitResult.SKIP_SUBTREE;
        });
        return ((ImmutableMultimap.Builder)builder).build();
    }
}

