/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.client.selection;

import com.gradle.c.b;
import com.gradle.enterprise.agent.a.g;
import com.gradle.enterprise.b.d.f;
import com.gradle.enterprise.testdistribution.client.api.TestSelectionException;
import com.gradle.enterprise.testdistribution.client.selection.ac;
import com.gradle.enterprise.testdistribution.client.selection.c;
import com.gradle.enterprise.testdistribution.client.selection.t;
import com.gradle.enterprise.testdistribution.client.selection.u;
import com.gradle.enterprise.testdistribution.client.selection.v;
import com.gradle.enterprise.testdistribution.client.selection.w;
import com.gradle.enterprise.testdistribution.client.selection.y;
import com.gradle.enterprise.testdistribution.launcher.protocol.message.ao;
import com.gradle.enterprise.testdistribution.launcher.protocol.message.as;
import com.gradle.enterprise.testselection.common.a.d;
import com.gradle.enterprise.testselection.common.model.api.v1.ClassNameHash;
import com.gradle.enterprise.testselection.common.model.api.v1.DebugData;
import com.gradle.enterprise.testselection.common.model.api.v1.FilePathHash;
import com.gradle.enterprise.testselection.common.model.api.v1.NonSelectionReasonId;
import com.gradle.enterprise.testselection.common.model.api.v1.PredictiveTestSelectionApiConstants;
import com.gradle.enterprise.testselection.common.model.api.v1.ResultType;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectTestsDebugResponse;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectTestsRequest;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectTestsResponse;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectionDebugData;
import com.gradle.enterprise.testselection.common.model.api.v1.SelectionReasonId;
import com.gradle.enterprise.testselection.common.model.api.v1.TestClassAndTime;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.databind.SmileMapper;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.tuple.Pair;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util.BytesContentProvider;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class a
implements u {
    private static final Duration b = Duration.ofSeconds(5L);
    private static final Duration c = Duration.ofSeconds(30L);
    private static final long d = c.minus(b).toMillis();
    private static final Logger e = LoggerFactory.getLogger(a.class);
    private final HttpClient f;
    private final w g;
    private final com.gradle.enterprise.testdistribution.client.connector.d h;
    private final SmileMapper i = com.gradle.enterprise.testselection.common.a.d.a();
    private final ObjectMapper j = com.gradle.enterprise.testselection.common.a.d.b();

    a(HttpClient httpClient, w serverOptions, com.gradle.enterprise.testdistribution.client.connector.d clientInfo) {
        this.f = httpClient;
        this.g = serverOptions;
        this.h = clientInfo;
    }

    @Override
    public com.gradle.enterprise.b.g.a<ac, y> selectTests(com.gradle.enterprise.version.buildagent.a buildToolType, String rootProjectName, String workUnitId, as originalTestPlan, v testTargetInputs, Optional<Duration> requestTimeout, boolean mustSelectAllTests, Set<ao> mustRunTests, boolean isDebugMode, Consumer<String> warningsConsumer) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        Pair<Set<ao>, Set<ao>> candidatesAndMustRun = a.a(originalTestPlan, mustRunTests, mustSelectAllTests);
        Map<ClassNameHash, List<ao>> candidatesClassNameHashes = a.a(candidatesAndMustRun.getLeft());
        Map<ClassNameHash, List<ao>> mustRunClassNameHashes = a.a(candidatesAndMustRun.getRight());
        HashMap<ClassNameHash, List<ao>> classNameHashes = new HashMap<ClassNameHash, List<ao>>(candidatesClassNameHashes);
        classNameHashes.putAll(mustRunClassNameHashes);
        Duration timeout = requestTimeout.orElseGet(() -> a.b(originalTestPlan.testCount()));
        SelectTestsRequest selectTestsRequest = SelectTestsRequest.create(rootProjectName, workUnitId, testTargetInputs.a(), candidatesClassNameHashes.keySet(), mustRunClassNameHashes.keySet(), timeout);
        ContentResponse response = this.a(selectTestsRequest, timeout, isDebugMode);
        int status = response.getStatus();
        e.debug("Response ({}): {}", (Object)status, (Object)response.getMediaType());
        if (status == 200 && "application/x-jackson-smile".equals(response.getMediaType())) {
            return this.a(classNameHashes, testTargetInputs.b(), response);
        }
        if (status == 403 || status == 401) {
            if (!response.getRequest().getHeaders().contains(HttpHeader.AUTHORIZATION)) {
                g printer = new g(warningsConsumer);
                printer.a(buildToolType, this.g.f(), this.g.e().a(), null, this.g.b());
            }
            return com.gradle.enterprise.b.g.a.b(y.CLIENT_UNAUTHORIZED);
        }
        if ("application/problem+json".equals(response.getMediaType())) {
            return com.gradle.enterprise.b.g.a.b(this.a(response));
        }
        if (a.a(status)) {
            return com.gradle.enterprise.b.g.a.b(y.BUILD_AGENT_NETWORK_UNAVAILABLE);
        }
        if (HttpStatus.isServerError(status)) {
            return com.gradle.enterprise.b.g.a.b(y.SERVICE_INTERNAL_ERROR);
        }
        throw new TestSelectionException("Unexpected response from server: " + response.getStatus() + " " + response.getReason() + " (" + response.getMediaType() + ")");
    }

    private static boolean a(int status) {
        switch (status) {
            case 501: 
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private static Pair<Set<ao>, Set<ao>> a(as originalTestPlan, Set<ao> mustRunTests, boolean mustSelectAllTests) {
        if (mustSelectAllTests) {
            return Pair.of(Collections.emptySet(), originalTestPlan.getTestIds());
        }
        if (mustRunTests.isEmpty()) {
            return Pair.of(originalTestPlan.getTestIds(), Collections.emptySet());
        }
        Set candidates = originalTestPlan.getTestIds().stream().filter(testId -> !mustRunTests.contains(testId)).collect(Collectors.toSet());
        return Pair.of(candidates, mustRunTests);
    }

    private static Duration b(int numberOfTestClasses) {
        double timeoutFactor = Math.min(1.0, (double)numberOfTestClasses / 1000.0);
        long scaledTimeout = (long)(timeoutFactor * (double)d);
        return Duration.ofMillis(scaledTimeout).plus(b);
    }

    private com.gradle.enterprise.b.g.a<ac, y> a(Map<ClassNameHash, List<ao>> classNameHashes, Map<FilePathHash, String> filePathsByHash, ContentResponse response) throws IOException {
        SelectTestsDebugResponse selectTestsResponse = this.c(response);
        ResultType resultType = selectTestsResponse.getResultType();
        e.debug("Selection Response: {}", (Object)resultType);
        switch (resultType) {
            case SELECT_TESTS: {
                return com.gradle.enterprise.b.g.a.a(a.a(selectTestsResponse, classNameHashes, filePathsByHash));
            }
            case INSUFFICIENT_DATA: {
                return com.gradle.enterprise.b.g.a.b(y.SERVICE_INSUFFICIENT_CHANGE_HISTORY);
            }
            case PROCESSING_LAGGING: {
                return com.gradle.enterprise.b.g.a.b(y.SERVICE_UNPROCESSED_EXECUTIONS);
            }
        }
        throw new f((Object)resultType);
    }

    private y a(ContentResponse response) throws IOException {
        com.gradle.a.a.a.a problem = this.b(response);
        e.debug("Selection Problem Response: {}", (Object)problem);
        return a.a(problem);
    }

    private static y a(com.gradle.a.a.a.a problem) {
        switch (problem.type()) {
            case "urn:gradle:enterprise:pts:disabled": {
                return y.SERVICE_EXTENSION_DISABLED;
            }
            case "urn:gradle:enterprise:pts:timeout": 
            case "urn:gradle:enterprise:pts:unsupportedVersion": {
                return y.SERVICE_INTERNAL_ERROR;
            }
        }
        throw new TestSelectionException("Unexpected problem response from server: " + problem);
    }

    private com.gradle.a.a.a.a b(ContentResponse response) throws IOException {
        return this.j.readValue(response.getContent(), com.gradle.a.a.a.a.class);
    }

    private ContentResponse a(SelectTestsRequest selectTestsRequest, Duration timeout, boolean isDebug) throws InterruptedException, TimeoutException, ExecutionException, IOException {
        Function<com.gradle.enterprise.version.buildagent.a, String> endpointResolver = isDebug ? PredictiveTestSelectionApiConstants.PTS_DEBUG_ENDPOINTS_BY_TOOL_TYPE::get : PredictiveTestSelectionApiConstants.PTS_ENDPOINTS_BY_TOOL_TYPE::get;
        URI url = this.g.f().resolve(endpointResolver.apply(this.h.a()));
        String requestId = UUID.randomUUID().toString();
        Request request = this.f.POST(url).content(this.a(selectTestsRequest), "application/x-jackson-smile").accept("application/x-jackson-smile", "application/problem+json").header(HttpHeader.CONTENT_ENCODING, "gzip").header("X-Request-Id", requestId).timeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        this.g.e().a(this.g.f().getHost(), this.g.c()).ifPresent(accessKey -> request.header(HttpHeader.AUTHORIZATION, "Bearer " + accessKey));
        if (e.isDebugEnabled()) {
            e.debug("Sending PTS request for project {}, test target {} with {} candidate tests and {} must run tests to {} with request ID {} using timeout {}", new Object[]{selectTestsRequest.getProjectCoordinates(), selectTestsRequest.getTargetPath(), selectTestsRequest.getCandidateTests().size(), selectTestsRequest.getMustRunTests().size(), url, requestId, timeout});
        }
        return request.send();
    }

    private BytesContentProvider a(SelectTestsRequest selectTestsRequest) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);){
            this.i.writeValue(gzipOutputStream, (Object)selectTestsRequest);
        }
        return new BytesContentProvider(new byte[][]{baos.toByteArray()});
    }

    private SelectTestsDebugResponse c(ContentResponse response) throws IOException {
        return this.i.readValue(response.getContent(), SelectTestsDebugResponse.class);
    }

    private static Map<ClassNameHash, List<ao>> a(Set<ao> originalTestPlan) {
        return originalTestPlan.stream().collect(Collectors.groupingBy(it -> ClassNameHash.hashOf(it.getLastSegment())));
    }

    private static ac a(SelectTestsDebugResponse selectTestsResponse, Map<ClassNameHash, List<ao>> classNameHashes, Map<FilePathHash, String> filePathsByHash) {
        as filteredTestPlan = a.a(classNameHashes, selectTestsResponse);
        Map<ac.e, Set<ao>> selectedTestClassesByReason = a.a(selectTestsResponse.getSelectedTests(), selectTestsResponse.getSelectionReasonDescriptions(), SelectionReasonId::getId, ac.e::b, classNameHashes);
        Map<ac.b, Set<ao>> notSelectedTestClassesByReason = a.a(selectTestsResponse.getNotSelectedTests(), selectTestsResponse.getNonSelectionReasonDescriptions(), NonSelectionReasonId::getId, ac.b::b, classNameHashes);
        Map<ao, Duration> durationsByTestId = Stream.concat(selectTestsResponse.getSelectedTests().values().stream().flatMap(Collection::stream), selectTestsResponse.getNotSelectedTests().values().stream().flatMap(Collection::stream)).filter(it -> it.getDuration() != null).flatMap(it -> ((List)classNameHashes.get(it.getClassNameHash())).stream().map(testId -> Pair.of(testId, it.getDuration()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ac.a debugData = a.a(selectTestsResponse.getDebugData(), classNameHashes, filePathsByHash);
        return ac.a(filteredTestPlan, selectedTestClassesByReason, notSelectedTestClassesByReason, durationsByTestId, debugData);
    }

    private static as a(Map<ClassNameHash, List<ao>> classNameHashes, SelectTestsResponse selectTestsResponse) {
        return as.valid(selectTestsResponse.getSelectedTests().values().stream().flatMap(Collection::stream).map(TestClassAndTime::getClassNameHash).map(classNameHashes::get).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    private static <I, O extends ac.c> Map<O, Set<ao>> a(Map<I, Set<TestClassAndTime>> testsByReasonId, Map<I, String> reasonDescriptionsByReasonId, ToIntFunction<I> reasonIdExtractor, a<O> reasonFactory, Map<ClassNameHash, List<ao>> classNameHashes) {
        return testsByReasonId.entrySet().stream().collect(Collectors.toMap(entry -> reasonFactory.create(reasonIdExtractor.applyAsInt(entry.getKey()), (String)reasonDescriptionsByReasonId.get(entry.getKey())), entry -> ((Set)entry.getValue()).stream().map(TestClassAndTime::getClassNameHash).map(classNameHashes::get).flatMap(Collection::stream).collect(Collectors.toSet())));
    }

    @b
    private static ac.a a(@b DebugData debugData, Map<ClassNameHash, List<ao>> classNameHashes, Map<FilePathHash, String> filePathsByHash) {
        if (debugData == null) {
            return null;
        }
        Map<ao, ac.d> selectionDebugDataByTestId = debugData.getSelectionDebugData().entrySet().stream().flatMap(entry -> {
            List testIds = (List)classNameHashes.get(entry.getKey());
            ac.d data = ac.d.a(((SelectionDebugData)entry.getValue()).getRelevanceScore(), ((SelectionDebugData)entry.getValue()).getModelFeatures(), debugData.getModelFeatureNames());
            return testIds.stream().map(testId -> Pair.of(testId, data));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<ClassNameHash, String> classNamesByHash = new HashMap<ClassNameHash, String>();
        classNameHashes.forEach((hash, testIds) -> classNamesByHash.put((ClassNameHash)hash, ((ao)testIds.get(0)).getLastSegment()));
        c hashResolver = com.gradle.enterprise.testdistribution.client.selection.c.a(filePathsByHash, classNamesByHash);
        return ac.a.b(debugData.getRequestId(), debugData.getInferenceDataHash(), debugData.getSelectionDuration(), selectionDebugDataByTestId, t.a(debugData.getInputs(), hashResolver::a), hashResolver);
    }

    private static interface a<T extends ac.c> {
        public T create(int var1, String var2);
    }
}

