/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jdk8;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalDouble;

class OptionalDoubleDeserializer
extends BaseScalarOptionalDeserializer<OptionalDouble> {
    static final OptionalDoubleDeserializer INSTANCE = new OptionalDoubleDeserializer();

    public OptionalDoubleDeserializer() {
        super(OptionalDouble.class, OptionalDouble.empty());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Float;
    }

    @Override
    public OptionalDouble deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return OptionalDouble.of(p2.getDoubleValue());
        }
        switch (p2.currentTokenId()) {
            case 6: {
                String text = p2.getText();
                Double specialValue = this._checkDoubleSpecialValue(text);
                if (specialValue != null) {
                    return OptionalDouble.of(specialValue);
                }
                CoercionAction act = this._checkFromStringCoercion(ctxt, text);
                if (act == CoercionAction.AsNull || act == CoercionAction.AsEmpty) {
                    return (OptionalDouble)this._empty;
                }
                text = text.trim();
                return OptionalDouble.of(this._parseDoublePrimitive(ctxt, text));
            }
            case 7: {
                return OptionalDouble.of(p2.getDoubleValue());
            }
            case 11: {
                return (OptionalDouble)this.getNullValue(ctxt);
            }
            case 3: {
                return (OptionalDouble)this._deserializeFromArray(p2, ctxt);
            }
        }
        return (OptionalDouble)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p2);
    }
}

