/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class JSR310StringParsableDeserializer
extends JSR310DeserializerBase<Object>
implements ContextualDeserializer {
    public static final JsonDeserializer<Period> PERIOD = JSR310StringParsableDeserializer.createDeserializer(Period.class, 1);
    public static final JsonDeserializer<ZoneId> ZONE_ID = JSR310StringParsableDeserializer.createDeserializer(ZoneId.class, 2);
    public static final JsonDeserializer<ZoneOffset> ZONE_OFFSET = JSR310StringParsableDeserializer.createDeserializer(ZoneOffset.class, 3);
    protected final int _typeSelector;

    protected JSR310StringParsableDeserializer(Class<?> supportedType, int typeSelector) {
        super(supportedType);
        this._typeSelector = typeSelector;
    }

    protected JSR310StringParsableDeserializer(JSR310StringParsableDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._typeSelector = base._typeSelector;
    }

    protected static <T> JsonDeserializer<T> createDeserializer(Class<T> type, int typeId) {
        return new JSR310StringParsableDeserializer(type, typeId);
    }

    protected JSR310StringParsableDeserializer withLeniency(Boolean leniency) {
        if (this._isLenient == !Boolean.FALSE.equals(leniency)) {
            return this;
        }
        return new JSR310StringParsableDeserializer(this, leniency);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        Boolean leniency;
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        JSR310StringParsableDeserializer deser = this;
        if (format != null && format.hasLenient() && (leniency = format.getLenient()) != null) {
            deser = this.withLeniency(leniency);
        }
        return deser;
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p2, ctxt, p2.getText());
        }
        if (p2.isExpectedStartObjectToken()) {
            return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, this, this.handledType()));
        }
        if (p2.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return p2.getEmbeddedObject();
        }
        if (p2.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(p2, ctxt);
        }
        throw ctxt.wrongTokenException(p2, this.handledType(), JsonToken.VALUE_STRING, null);
    }

    @Override
    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer deserializer) throws IOException {
        JsonToken t2 = parser.getCurrentToken();
        if (t2 != null && t2.isScalarValue()) {
            return this.deserialize(parser, context);
        }
        return deserializer.deserializeTypedFromAny(parser, context);
    }

    protected Object _fromString(JsonParser p2, DeserializationContext ctxt, String string) throws IOException {
        if ((string = string.trim()).length() == 0) {
            CoercionAction act = ctxt.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.EmptyString);
            if (act == CoercionAction.Fail) {
                ctxt.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", this._coercedTypeDesc());
            }
            if (!this.isLenient()) {
                return this._failForNotLenient(p2, ctxt, JsonToken.VALUE_STRING);
            }
            if (act == CoercionAction.AsEmpty) {
                return this.getEmptyValue(ctxt);
            }
            return null;
        }
        try {
            switch (this._typeSelector) {
                case 1: {
                    return Period.parse(string);
                }
                case 2: {
                    return ZoneId.of(string);
                }
                case 3: {
                    return ZoneOffset.of(string);
                }
            }
        }
        catch (DateTimeException e2) {
            return this._handleDateTimeException(ctxt, e2, string);
        }
        VersionUtil.throwInternal();
        return null;
    }
}

