/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.hash;

import java.io.Serializable;

public abstract class HashCode {
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    HashCode() {
    }

    public abstract int bits();

    public abstract int asInt();

    public abstract long asLong();

    public abstract byte[] asBytes();

    byte[] getBytesInternal() {
        return this.asBytes();
    }

    abstract boolean equalsSameBits(HashCode var1);

    public static HashCode fromLong(long hash) {
        return new LongHashCode(hash);
    }

    public final boolean equals(Object object) {
        if (object instanceof HashCode) {
            HashCode that = (HashCode)object;
            return this.bits() == that.bits() && this.equalsSameBits(that);
        }
        return false;
    }

    public final int hashCode() {
        if (this.bits() >= 32) {
            return this.asInt();
        }
        byte[] bytes = this.getBytesInternal();
        int val = bytes[0] & 0xFF;
        for (int i2 = 1; i2 < bytes.length; ++i2) {
            val |= (bytes[i2] & 0xFF) << i2 * 8;
        }
        return val;
    }

    public final String toString() {
        byte[] bytes = this.getBytesInternal();
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b2 : bytes) {
            sb.append(hexDigits[b2 >> 4 & 0xF]).append(hexDigits[b2 & 0xF]);
        }
        return sb.toString();
    }

    private static final class LongHashCode
    extends HashCode
    implements Serializable {
        final long hash;

        LongHashCode(long hash) {
            this.hash = hash;
        }

        @Override
        public int bits() {
            return 64;
        }

        @Override
        public byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24), (byte)(this.hash >> 32), (byte)(this.hash >> 40), (byte)(this.hash >> 48), (byte)(this.hash >> 56)};
        }

        @Override
        public int asInt() {
            return (int)this.hash;
        }

        @Override
        public long asLong() {
            return this.hash;
        }

        @Override
        boolean equalsSameBits(HashCode that) {
            return this.hash == that.asLong();
        }
    }
}

