/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe;

import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionImpl;
import com.gradle.maven.extension.internal.dep.dev.failsafe.FailsafeExecutor;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.PolicyExecutor;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.Scheduler;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.SyncExecutionInternal;
import java.util.function.Function;

final class SyncExecutionImpl<R>
extends ExecutionImpl<R>
implements SyncExecutionInternal<R> {
    private final FailsafeExecutor<R> executor;
    private Function<SyncExecutionInternal<R>, ExecutionResult<R>> outerFn;
    private volatile boolean interruptable;
    private volatile boolean interrupted;
    private final SyncExecutionInternal<R> initial;

    SyncExecutionImpl(FailsafeExecutor<R> executor, Scheduler scheduler, Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn) {
        super(executor.policies);
        this.executor = executor;
        this.initial = this;
        this.outerFn = innerFn;
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerFn = policyExecutor.apply(this.outerFn, scheduler);
        }
    }

    private SyncExecutionImpl(SyncExecutionImpl<R> execution) {
        super(execution);
        this.executor = execution.executor;
        this.interruptable = execution.interruptable;
        this.interrupted = execution.interrupted;
        this.initial = execution.initial;
    }

    @Override
    public synchronized void preExecute() {
        if (this.isStandalone()) {
            this.attemptRecorded = false;
            this.cancelledIndex = Integer.MIN_VALUE;
            this.interrupted = false;
        }
        super.preExecute();
        this.interruptable = true;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterruptable(boolean interruptable) {
        this.interruptable = interruptable;
    }

    @Override
    public SyncExecutionInternal<R> getInitial() {
        return this.initial;
    }

    private boolean isStandalone() {
        return this.executor == null;
    }

    @Override
    public SyncExecutionImpl<R> copy() {
        return this.isStandalone() ? this : new SyncExecutionImpl<R>(this);
    }

    ExecutionResult<R> executeSync() {
        ExecutionResult<R> result = this.outerFn.apply(this);
        this.completed = result.isComplete();
        this.executor.completionHandler.accept(result, this);
        return result;
    }
}

