/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe.spi;

import com.gradle.maven.extension.internal.dep.dev.failsafe.DelayablePolicyConfig;
import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.dev.failsafe.Policy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.PolicyConfig;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.util.Durations;
import java.time.Duration;

public interface DelayablePolicy<R>
extends Policy<R> {
    @Override
    public DelayablePolicyConfig<R> getConfig();

    default public Duration computeDelay(ExecutionContext<R> context) {
        PolicyConfig config = this.getConfig();
        Duration computed = null;
        if (context != null && ((DelayablePolicyConfig)config).getDelayFn() != null) {
            boolean delayFailureMatched;
            R exResult = context.getLastResult();
            Object exFailure = context.getLastFailure();
            Object delayResult = ((DelayablePolicyConfig)config).getDelayResult();
            Class<Throwable> delayFailure = ((DelayablePolicyConfig)config).getDelayFailure();
            boolean delayResultMatched = delayResult == null || delayResult.equals(exResult);
            boolean bl2 = delayFailureMatched = delayFailure == null || exFailure != null && delayFailure.isAssignableFrom(exFailure.getClass());
            if (delayResultMatched && delayFailureMatched) {
                try {
                    computed = Durations.ofSafeNanos(((DelayablePolicyConfig)config).getDelayFn().get(context));
                }
                catch (Throwable e2) {
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    throw new RuntimeException(e2);
                }
            }
        }
        return computed != null && !computed.isNegative() ? computed : null;
    }
}

