/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Invocable;
import java.util.function.Consumer;

public interface Callback
extends Invocable {
    public static final Callback NOOP = new Callback(){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    };

    default public void succeeded() {
    }

    default public void failed(Throwable x2) {
    }

    public static Callback from(Runnable success, Consumer<Throwable> failure) {
        return Callback.from(Invocable.InvocationType.BLOCKING, success, failure);
    }

    public static Callback from(final Invocable.InvocationType invocationType, final Runnable success, final Consumer<Throwable> failure) {
        return new Callback(){

            @Override
            public void succeeded() {
                success.run();
            }

            @Override
            public void failed(Throwable x2) {
                failure.accept(x2);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }
        };
    }

    public static class Nested
    extends Completing {
        private final Callback callback;

        public Nested(Callback callback) {
            this.callback = callback;
        }

        @Override
        public void succeeded() {
            try {
                this.callback.succeeded();
            }
            finally {
                this.completed();
            }
        }

        @Override
        public void failed(Throwable x2) {
            try {
                this.callback.failed(x2);
            }
            finally {
                this.completed();
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.callback.getInvocationType();
        }
    }

    public static class Completing
    implements Callback {
        @Override
        public void succeeded() {
            this.completed();
        }

        @Override
        public void failed(Throwable x2) {
            this.completed();
        }

        public void completed() {
        }
    }
}

