/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.UpgradeRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.util.QuoteUtil;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UpgradeRequestAdapter
implements UpgradeRequest {
    private URI requestURI;
    private List<String> subProtocols = new ArrayList<String>(1);
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>(1);
    private List<HttpCookie> cookies = new ArrayList<HttpCookie>(1);
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>(1);
    private String httpVersion;
    private String method;
    private String host;
    private boolean secure;

    protected UpgradeRequestAdapter() {
    }

    public UpgradeRequestAdapter(URI requestURI) {
        this.setRequestURI(requestURI);
    }

    public void addExtensions(ExtensionConfig ... configs) {
        Collections.addAll(this.extensions, configs);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        int size = values.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return values.get(0);
        }
        boolean needsDelim = false;
        StringBuilder ret = new StringBuilder();
        for (String value : values) {
            if (needsDelim) {
                ret.append(", ");
            }
            QuoteUtil.quoteIfNeeded(ret, value, "\"'\\\n\r\t\f\b%+ ;=");
            needsDelim = true;
        }
        return ret.toString();
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String getProtocolVersion() {
        String version = this.getHeader("Sec-WebSocket-Version");
        if (version == null) {
            return "13";
        }
        return version;
    }

    public void setCookies(List<HttpCookie> cookies) {
        this.cookies.clear();
        if (cookies != null && !cookies.isEmpty()) {
            this.cookies.addAll(cookies);
        }
    }

    public void setHeader(String name, List<String> values) {
        this.headers.put(name, values);
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.clearHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            this.setHeader(name, values);
        }
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    protected void setParameterMap(Map<String, List<String>> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public void setRequestURI(URI uri) {
        this.requestURI = uri;
        String scheme = uri.getScheme();
        if ("ws".equalsIgnoreCase(scheme)) {
            this.secure = false;
        } else if ("wss".equalsIgnoreCase(scheme)) {
            this.secure = true;
        } else {
            throw new IllegalArgumentException("URI scheme must be 'ws' or 'wss'");
        }
        this.host = this.requestURI.getHost();
        this.parameters.clear();
    }

    public void setSubProtocols(String ... protocols) {
        this.subProtocols.clear();
        Collections.addAll(this.subProtocols, protocols);
    }
}

