/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.mojo;

import com.gradle.enterprise.testdistribution.client.d.c;
import com.gradle.enterprise.testdistribution.client.selection.b;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.obfuscation.KeepNonTransientFieldNames;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Mojo.class, hint="gradle-enterprise-pts-remap-fingerprints-mojo")
@KeepNonTransientFieldNames
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class FingerprintMapperMojo
extends AbstractMojo {
    private File inputFile;
    private File hashMapFile;

    public void execute() throws MojoExecutionException {
        Path inputFilePath = this.inputFile.toPath();
        Path outputFilePath = FingerprintMapperMojo.getOutputFilePath(inputFilePath);
        this.getLog().info((CharSequence)("Remapped file will be written to " + outputFilePath));
        try (OutputStream outputStream = Files.newOutputStream(outputFilePath, new OpenOption[0]);){
            FingerprintMapperMojo.remapFileBasedInputs(inputFilePath, this.hashMapFile.toPath(), outputStream);
        }
        catch (IOException e2) {
            throw new MojoExecutionException("Failed to remap input file", (Exception)e2);
        }
    }

    private static void remapFileBasedInputs(Path inputFilePath, Path hashMapFilePath, OutputStream outputStream) throws IOException {
        com.gradle.enterprise.testdistribution.client.selection.c hashResolver = c.a().readValue(Files.readAllBytes(hashMapFilePath), com.gradle.enterprise.testdistribution.client.selection.c.class);
        try (InputStream fileToRemapStream = Files.newInputStream(inputFilePath, new OpenOption[0]);){
            JsonNode root = c.a().readTree(fileToRemapStream);
            b.a(root, hashResolver);
            c.a().writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)root);
        }
    }

    private static Path getOutputFilePath(Path inputFilePath) {
        return inputFilePath.getParent().resolve(inputFilePath.getFileName() + ".mapped.json");
    }
}

